#ifndef AT_COMMAND
#define AT_COMMAND

#define STATUS_OK                0
#define STATUS_ERROR             1
#define STATUS_INVALID_COMMAND   2
#define STATUS_INVALID_PARAMETER 3
#define STATUS_TX_FAILURE        4

#define IO_SAMPLE_RX_INDICATOR   0x92

#define AT_COMMAND_RESPONSE      0x88
#define PacketAcknowledged       1
#define PacketBroadcast          2

#include "mbed.h"

// Application
void print(Serial *pc, char buff[]);
void toggleError(Serial *xbee, Serial *pc,int timeout, char * msg);
//void waitForConnection(Serial *xbee, Serial *pc, char * macAddr);
void sendAccData(Serial *xbee, Serial *pc, char * macAddr ,char D[4]);
int decodePacket(Serial *xbee, Serial *pc, char *packet, int len);
int receiveAcknowledge(Serial *xbee, Serial *pc);

// Network
char getStatusResponse(Serial *xbee, Serial *pc);
int ND(Serial *xbee, Serial *pc, char * macAddr);

//  MAC
int  isStartDelimiter(Serial *xbee, Serial *pc);
int  getLenght(Serial *xbee, Serial *pc);
char * readFrame(Serial *xbee, Serial *pc);
char * readParam(Serial *xbee, Serial *pc);

// PHY
char read (Serial *xbee, Serial *pc, char *msg);
char * read(Serial *xbee, Serial *pc, int nbyte,  char* msg);
void send (Serial *xbee, Serial *pc, char *b, int size);
void sendAT(Serial *xbee, Serial *pc, char* command, char* params, int lenparams);
void sendTR(Serial *xbee, Serial *pc, char* macAddr, char *RFdata,int len);
char checksum(char* array, int size);
void ATWR (Serial *xbee, Serial *pc);
void apply(Serial *xbee, Serial *pc);
void flush(Serial *xbee, Serial *pc);

#endif
