#include "ATcommand.h"
int timeout = 5000;
char off[9] = {0x7E,0x00,0x05,0x09,0x01,0x44,0x30,0x04,0x7D};
char on[9]  = {0x7E,0x00,0x05,0x09,0x01,0x44,0x30,0x05,0x7C};

//--------------------------------------------
//------------- Application ------------------
//--------------------------------------------
void print(Serial *pc, char buff[]);
void toggleError(Serial *xbee, Serial *pc, int delay, char * msg){
    pc->printf("\n\r !!!!!!!!!!! %s !!!!!!!!!!!",msg);
    flush(xbee,pc);
    send(xbee,pc, on, 9);  flush(xbee,pc);
    ATWR(xbee, pc);        flush(xbee,pc);
    apply(xbee, pc);       flush(xbee,pc);
    
    wait_ms(delay);
    
    send(xbee,pc, off, 9);  flush(xbee,pc);
    ATWR(xbee, pc);         flush(xbee,pc);
    apply(xbee, pc);        flush(xbee,pc);
}

void waitForConnection(Serial *xbee, Serial *pc, char * macAddr){
    while(ND(xbee, pc, macAddr)==-1){}
    pc->printf("MAC FOUND");
    flush(xbee,pc);
}

void sendAccData(Serial *xbee, Serial *pc, char * macAddr ,char D[4]){
    pc->printf("\n\rTransmit Data Request");
    sendTR(xbee, pc, macAddr, D, 4);    
}

int decodePacket(Serial *xbee, Serial *pc, char *packet, int len){
    int ret = 0;
    switch(packet[0]){
        case 0x92:  char * params= NULL;
                    params = readParam(xbee, pc);
                    free(params);    
                    ret =  -1;
                    break;
        case 0x8B:  bool status = (packet[6]== 0x00);
                    if(status){
                        pc->printf("\n\rData send succes");
                        ret= 0;
                    }else{
                        pc->printf("\n\rData send failed. Status: 0x%X",packet[6]);
                        ret= -1;
                    }
            
                    break;
        default:    pc->printf("\n\rTO DO: decoder for frame type 0x%x",packet[0]); break;
    }
    return ret;
}

int receiveAcknowledge(Serial *xbee, Serial *pc){
    char *packet = NULL;
    int ret = 0;
    if(0 == isStartDelimiter(xbee, pc)){
        int l = getLenght(xbee, pc);
        packet = readFrame(xbee, pc);
        ret = decodePacket(xbee, pc, packet,l );
    }else{
         toggleError(xbee, pc, 200, "Error in FrameID");
         ret = -1;   
    }
    free(packet);
    return ret;
}

//--------------------------------------------
//----------------- Network ------------------
//--------------------------------------------
char getStatusResponse(Serial *xbee, Serial *pc){
    char *buf;
    char status;
    buf = read(xbee, pc,2, "AT Command");
    free(buf);
    
    char *frame = NULL;
    frame =  readFrame(xbee, pc);
    status = frame[5];
    free(frame);
    return status;
}

int ND(Serial *xbee, Serial *pc, char * macAddr){
    char AT_ND[2] =  {0x4E,0x44};
    sendAT(xbee, pc, AT_ND, NULL, 0);
    free(AT_ND);
    
    int time = timeout;
    while(time >=0){
        //wait_ms(10);
        time -= 10;
        if(xbee->readable()){
            isStartDelimiter(xbee,pc);
            int len = getLenght(xbee,pc);
            
            char *c;
            c = readFrame(xbee, pc);
            
            
            if(len>14){
                pc->printf("\n\r\tMAC adresse:");   
                for(int i=0; i<8;i++){
                    macAddr[i] =  c[i+7];
                    pc->printf("0x%x ", c[i+7]);
                }   
            }else{
                toggleError(xbee, pc, 200, "\n\r !!! Mac adresse not return !!!");
                return -1;
            }
            flush(xbee,pc);
            free(c);
            return 0;
        }
    }
    pc->printf("WARNING : Connection Lost!");
    return -1;
}


//--------------------------------------------
//------------------- MAC --------------------
//--------------------------------------------
int isStartDelimiter(Serial *xbee, Serial *pc){
    pc->printf("\n\r\tRECEIVE:");
    return (xbee->getc() == 0x7E) ? 0 : -1;
}
int getLenght(Serial *xbee, Serial *pc){
    char *buf;
    buf = read(xbee, pc, 2, "Lenght");
    int result = buf[0] << 8 | buf[1];                
    free(buf);
    return result;                       
}
char * readFrame(Serial *xbee, Serial *pc){
    int l = 0;
    char *packet = NULL;
    while(xbee->readable()) {
        packet = (char*)realloc(packet ,sizeof(char)*(l+1));
        packet[l++] = xbee->getc();
    }
    //wait_ms(10);  // CPU to fast  
    pc->printf("\n\r\tFrame:");   
    for(int i=0; i<l; i++){
        pc->printf("0x%x ",packet[i]);
    }
    return packet;
}
char * readParam(Serial *xbee, Serial *pc){
    int l = 0;
    char *packet = NULL;
    while(xbee->readable()) {
        packet = (char*)realloc(&packet[0],sizeof(char)*(l+1));
        packet[l++] = xbee->getc();
    }    
    //wait_ms(50);  // CPU to fast
    pc->printf("\n\r\tParams:");   
    for(int i=0; i<l; i++){
        pc->printf("0x%x ",packet[i]);
    }
    return packet;
}



//--------------------------------------------
//------------------- PHY --------------------
//--------------------------------------------
char read(Serial *xbee, Serial *pc, char* msg){
    char c;
    pc->printf("\n\r\t %s:",msg);
    c = xbee->getc();
    pc->printf(" 0x%X", c);
    if(strstr(msg, "Status")!= NULL){
        if((int)c != 0){
            toggleError(xbee, pc, 200, "Bad Status");
        }
    }
    //wait_ms(10);// CPU to fast  
    return c;
}
void send(Serial* xbee, Serial* pc, char * b, int size){
    pc->printf("\n\r\tSEND:");
    for(int i=0 ;i<size; i=i++){
        xbee->putc(b[i]);
        pc->printf(" 0x%X", b[i]);
    }
}
void sendAT(Serial *xbee, Serial *pc, char* command, char* params, int lenparams){
    uint8_t len = 4 +  lenparams;
    //printf("Lenght is: %d\n", len);

    char c[4+len];
    c[0]= 0x7E;
    c[1]= len >> 8 ;
    c[2]= len;
    
    c[3]= 0x09;
    c[4]= 0x01;
    c[5] = command[0];
    c[6] = command[1];
    int i =0;
    for(; i<lenparams; i++){
        c[i+7] = params[i];
    }
    char check;
    check = checksum(c,lenparams+4 );
    c[i+7] = check;
    
    send(xbee,pc, c,len+4);
    free(c);
}

void sendTR(Serial *xbee, Serial *pc, char macAddr[8], char RFdata[], int lenparams ){
    uint8_t len = 14 +  lenparams;

    char c[4+len];
    c[0]= 0x7E;
    c[1]= len >> 8 ;
    c[2]= len;
    
    c[3]= 0x10;
    c[4]= 0x01;
    c[5] = macAddr[0];
    c[6] = macAddr[1];
    c[7] = macAddr[2];
    c[8] = macAddr[3];
    c[9] = macAddr[4];
    c[10] = macAddr[5];
    c[11] = macAddr[6];
    c[12] = macAddr[7];
    c[13] = 0xFF;
    c[14] = 0xFE;
    c[15] = 0x00;
    c[16] = 0x00;
    int i =0;
    for(; i<lenparams; i++){
        c[i+17] = RFdata[i];
    }
    char check;
    check = checksum(c,len);
    c[i+17] = check;
    
    send(xbee,pc, c,4+len);
    free(c);
}

char checksum(char* array, int size){
    char checksum = 0x00;
    for(int x = 3; x < size+3; x++){
      checksum += array[x];
      //printf("\n\r 0x%X --> 0x%x",array[x],checksum);
    }
    //printf("\n\r substract 0xFF");
    checksum = 0xFF - checksum;
    //printf("\n\rChecksum is: 0x%x\n", checksum);
    return checksum; 
}

void ATWR(Serial *xbee, Serial *pc){
    char c[8] = {0x7E,0x00,0x04,0x09,0x01,0x57,0x52,0x4C};
    send(xbee,pc, c,8);
    //free(c);
}
void apply(Serial *xbee, Serial *pc){
    char c[8] = {0x7E,0x00,0x04,0x09,0x01,0x41,0x43,0x71};
    send(xbee,pc, c,8);
    //free(c);
}
void flush(Serial *xbee, Serial *pc){
    while(xbee->readable()) {
        char c = xbee->getc();
        //pc->printf("%X ",c);
    }
}


char * read(Serial *xbee, Serial *pc, int nbyte,  char* msg){
    pc->printf("\n\r\t%s:",msg);
    char *buff = NULL;
    if(xbee->readable()) {
        for(int i=0; i<nbyte; i++){
            buff = (char*)realloc(buff ,sizeof(char)*(i+1));
            buff[i] = xbee->getc();
        }
    }
    
    //wait_ms(10); // CPU to fast
    for(int i=0; i<nbyte; i++){
        pc->printf("0x%X ", buff[i]);
    }
    return buff;
}
