#include "mbed.h"
#include "Adafruit_SSD1306.h"

DigitalOut myled(LED1);

#define PR_3

#ifdef Test
int main()
{
    I2C     I2C_Oled(PB_7, PA_15);
    I2C_Oled.frequency(400000);
    
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PA_1);
    myOled.splash();
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();
    wait(1);
    
    uint16_t n = 0;
    
    while(1)
    {
        myled = !myled;
        myOled.clearDisplay();
        myOled.setTextCursor(1,5);
        myOled.printf("<<< UNIST DHE: %u >>>", n++);
        myOled.display();
        wait(0.1);
    }
} 
#endif

#ifdef PR_1
int main()
{
    I2C     I2C_Oled(PB_7, PA_15);
    I2C_Oled.frequency(400000);
    
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PA_1);
    myOled.splash();
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();
    wait(1);
    
    while(1)
    {
        myOled.clearDisplay();
        myOled.setTextCursor(1,5);
        myled = !myled;
        
        myOled.display();
    }
} 
#endif

#ifdef PR_2
int main()
{
    I2C     I2C_Oled(PB_7, PA_15);
    I2C_Oled.frequency(400000);
    
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PA_1);
    myOled.splash();
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();
    wait(1);
    
    while(1)
    {
        myOled.clearDisplay();
        myOled.setTextSize(3);
        myOled.setTextColor(BLACK, WHITE);
        myOled.setTextCursor(1,1);
        myOled.printf("Read This?");
        myOled.display();
        wait(1); 
        myOled.clearDisplay();
        myOled.setTextSize(2);
        myOled.setTextColor(BLACK, WHITE);
        myOled.setTextCursor(1,1);
        myOled.printf("How About This?");
        myOled.display();
        wait(1);
        myOled.clearDisplay();
        myOled.setTextSize(1);
        myOled.setTextColor(BLACK, WHITE);
        myOled.setTextCursor(1,1);
        myOled.printf("Really?");
        myOled.display();
        wait(1);
        myOled.clearDisplay();
        myOled.setTextColor(WHITE);
        myOled.setTextCursor(0,0);
        myOled.setTextSize(1);
        myOled.printf("A");
        myOled.setTextSize(2);
        myOled.printf("A");
        myOled.setTextSize(3);
        myOled.printf("A");
        myOled.setTextSize(4);
        myOled.printf("A");
        myOled.setTextSize(5);
        myOled.printf("A");
        myOled.setTextSize(6);
        myOled.printf("A");
        myOled.display();
        wait(1);
        myOled.clearDisplay();
        myOled.clearDisplay(); 
        myOled.drawRect(100, 10, 20, 20, WHITE);
        myOled.display();
        wait(1);
        myOled.fillRect(10, 10, 45, 15, WHITE);
        myOled.display();
        wait(1);
        myOled.drawRoundRect(60, 20, 35, 35, 8, WHITE);
        myOled.display();
        wait(1);
        myOled.drawCircle(60, 30, 30, WHITE);
        myOled.display();
        wait(1);
        myOled.fillCircle(100, 20, 5, WHITE);
        myOled.display();
        wait(1);
        myOled.fillCircle(70, 20, 5, WHITE);
        myOled.display();
        wait(1);
        myOled.drawTriangle(24, 1, 3, 55, 45, 55, WHITE);
        myOled.display();
        wait(1);
        myOled.fillTriangle(104, 62, 125, 9, 83, 9, WHITE);
        myOled.display();
        wait(1);
    }
} 
#endif

#ifdef PR_3
int main()
{
    I2C     I2C_Oled(PB_7, PA_15);
    I2C_Oled.frequency(400000);
    
    Adafruit_SSD1306_I2c    myOled(I2C_Oled, PA_1);
    myOled.splash();
    myOled.display();
    wait(0.5);
    
    myOled.clearDisplay();
    myOled.printf("%u x %u OLED Display\r\n", myOled.width(), myOled.height());
    myOled.display();
    wait(1);
    
    static const unsigned char panda[] =
{

};
    while(1)
    {
        myOled.clearDisplay();
        myOled.drawBitmap(32,16,panda, 64, 32, WHITE);
        myOled.display();
        wait(0.5);
    }
} 
#endif