// made by H. S. Lee. 2019-10-28
// DAC Test for F303RE

#include "mbed.h"
#include "Adafruit_SSD1306.h"   // Adafruit_GFX library
Ticker DACtimer;
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut  Board_led(LED1);
DigitalOut  Out_led(PA_12);
DigitalIn   myButton(PC_13);
DigitalIn   exButton(PC_11);
AnalogOut  myAnalogOut(PA_4);
bool flagTimer = 0;
BusOut My7segment_pin(PA_8, PA_9, PA_10, PC_9, PC_8, PC_7, PC_6, PA_11); // 8bit data
            // LSB,                                      , MSB
char    val7Seg[16] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F,
                        0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};
char rxData[5];
bool flagRx = 0;
int delay =0;

#define Pr_2_3

#ifdef  TEST1

int main(void)
{
    pc.baud(115200);
    pc.puts("\n TESt1: Starting Program \n");
    
    while (1) {
        // change the voltage on the digital output pin by 0.1 * VCC
        //  and print what the measured voltage should be (assuming VCC = 3.3v)
        for (float n = 0.0f; n < 1.0f; n += 0.1f) {
            myAnalogOut = n;
//            myAnalogOut.write(n);
            
            pc.printf("n=%1.2f, output = %1.2f volts\n", n, myAnalogOut.read() * 3.3f);
            // turn on the led if the voltage is greater than 0.5f * VCC
            Board_led = (myAnalogOut > 0.5f) ? 1 : 0;
            wait(0.1);
        }
    }
}
#endif

#ifdef  TEST2
Ticker  DACtimer;
bool    flagTimer = 0;

void DACInt()
{
    flagTimer = 1;
}

main()
{
    pc.baud(115200);
    pc.puts("\n Test2: Starting Program \n");
        
    // for 10kHz sine wave generation, it's needed to have 
    // a sampling frequency in 10 times of that frequency, 
    // or 100kHz -> 10us period
    const float samplingTime = 0.00005;

    DACtimer.attach(&DACInt, samplingTime);      // 50us is appropriate for F303RE (20kHz)
//    DACtimer.attach_us(&DACInt, samplingTime*1000000);      // 50us is appropriate for F303RE
    
    float soundFreq = 1000;      // 1kHz = 1000Hz
    pc.printf("smapling time = %dus, sound frequency = %dHz\n", (int)(samplingTime*1000000),   (int)soundFreq);
    
    unsigned int n = 0; 
    float tempVal;
    while(1)
    {
        if (1 == flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(2*3.14159*tempVal)*0.5+0.5;        // an angle is expressed in radians.
//            myAnalogOut = (sin(2*3.14159*tempVal)+sin(tempVal))*0.25+0.5;        // an angle is expressed in radians.
            if (tempVal > 1.0f) n = 0;      // to prevent a phase shift due to overflow of the unsinged int variable
            n++;
        }    
    }       
}
#endif


#ifdef Pr_1
void DACInt()
{
    flagTimer = 1;
}

main()
{
    pc.baud(115200);
    pc.puts("\n Test2: Starting Program \n");
    
    const float samplingTime = 0.00005;
    DACtimer. attach(&DACInt, samplingTime);
    float soundFreq = 400.0f;
    float soundFreq_count = 0.0275f;
    unsigned int n = 0;
    float tempVal;
    while(1)
    {
        if (1==flagTimer)
        {
                flagTimer = 0;
                tempVal = soundFreq*n*samplingTime;
                myAnalogOut = sin(2 * 3.14159 * tempVal) * 0.5 + 0.5;
//            myAnalogOut = (sin(2*3.14159*tempVal)+sin(tempVal))*0.25+0.5;        // an angle is expressed in radians.Q
                soundFreq = soundFreq + soundFreq_count;
                if(2000<soundFreq) soundFreq_count = -soundFreq_count;
                if(400>soundFreq) soundFreq_count = -soundFreq_count;
                if(tempVal>1.0f)n=0;
                n++;
//                if(12000.0f < n) n = 0;
                       
        }
        
    }
}
#endif


#ifdef Pr_2_3
void ReceiveInt()
{
    char inChar;
    static char rxCount = 0;
    static char rxBuf[5];
    
    while(1 == pc.readable())
    {
        inChar=pc.getc();
        pc.putc(inChar);
        if ('<' == inChar)
        {
            rxCount = 1;
        }
        else if (rxCount > 0 && rxCount < 5)
        {
            rxBuf[rxCount - 1] = inChar;
            rxCount++;
        }
        else if (rxCount == 5 && '>' == inChar)
        {
            rxCount = 0;
            flagRx = 1;
            memcpy(rxData,rxBuf,rxCount-1);
        }
        else
        {
            rxCount = 0;
        } 
    }  
}

void DACInt()
{
    flagTimer = 1;
}

main()
{
    pc.baud(115200);
    pc.puts("\n Practice2: Starting Program \n");
    pc.attach(&ReceiveInt,Serial::RxIrq);
    
    char tmpCommand[3];
    int rxVal;
    Board_led=1;
    const float samplingTime = 0.00005;
    DACtimer. attach(&DACInt, samplingTime);
    float soundFreq = 400.0f;
    unsigned int n = 0;
    float tempVal;
    double soundVolume = 2;
    double squaremaker = 0.0005;

    while(1)
    {
        if(1 == flagRx)
        {
            flagRx=0;
            tmpCommand[0]=rxData[0];
            tmpCommand[1]=rxData[1];
            tmpCommand[2]=0;
            rxVal = atoi(rxData + 2);
            if(!strcmp(tmpCommand,"SI"))
            {
                pc.printf("Sine Wave: %d\n",rxVal);
                soundFreq = rxVal*10.0f;
                flagTimer = 2;
            }
            else if(!strcmp(tmpCommand,"SQ"))
            {
                pc.printf("Square Wave: %d\n",rxVal);
                flagTimer = 3;
            }
            else if(!strcmp(tmpCommand,"PL"))
            {
                pc.printf("Play Limit: %d\n",rxVal);
                soundVolume = 0;
                flagTimer = 4;
            }
            else if(!strcmp(tmpCommand,"VL"))
            {
                pc.printf("Volume Limit: %d\n",rxVal);
                soundVolume = rxVal*1.0f;
                flagTimer = 5;
            }
            else if(!strcmp(tmpCommand,"TR"))
            {
                pc.printf("Triangle Wave: %ds\n",rxVal);
                flagTimer = 6;
            }
            else if(!strcmp(tmpCommand,"SA"))
            {
                pc.printf("Sawtooth Wave: %d\n",rxVal);
                flagTimer = 7;
            }            
        }

        if (2==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5+0.5;       
            if (tempVal > 1.0f) n = 0;      
            n++;
        }
        else if (3==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*squaremaker;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5+0.5;        
            if (tempVal > 1.0f) n = 0;      
            n++;
        }
        else if (4==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5+0.5;      
            if (tempVal > 1.0f) n = 0;      
            n++;
        } 
        else if (5==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5+0.5;        
            if (tempVal > 1.0f) n = 0;     
            n++;
        } 
        else if (6==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5 + 0.5 + 0.5 * sin((soundVolume * 3.14159 * tempVal)*2) * 0.5 + 0.33 * sin((soundVolume + 3.14159 + tempVal)*3) * 0.5 + 0.5 + 0.25 * sin((soundVolume + 3.14159 + tempVal)*4) * 0.5 + 0.5 + 0.2 * sin((soundVolume + 3.14159 + tempVal)*5) * 0.5 + 0.5 + 0.166 * sin((soundVolume + 3.14159 + tempVal)*6) * 0.5 + 0.5;
            if (tempVal > 1.0f) n = 0; 
            n++;
        }
        else if (7==flagTimer)
        {
            flagTimer = 0;
            tempVal = soundFreq*n*samplingTime;
            myAnalogOut = sin(soundVolume*3.14159*tempVal)*0.5 + 0.5 + 0.33 * sin((soundVolume * 3.14159 * tempVal)*3 ) * 0.5 + 0.2 * sin((soundVolume + 3.14159 + tempVal)*5) * 0.5 + 0.5 + 0.144 * sin((soundVolume + 3.14159 + tempVal)*7) * 0.5 + 0.5 + 0.111 * sin((soundVolume + 3.14159 + tempVal)*9) * 0.5 + 0.5 + 0.0999 * sin((soundVolume + 3.14159 + tempVal)*11) * 0.5 + 0.5;
            if (tempVal > 1.0f) n = 0;     
            n++;
        }      
        
    }
}
#endif