
#include <string>
#include <vector>
#include "mbed.h"
#include "easy-connect.h"
#include "Websocket.h"
#include "MbedJSONValue.h"

 /* connect this pin to both the CH_PD (aka EN) & RST pins on the ESP8266 just in case */
#define _threshold 2000.0
#define SERVER_IP "192.168.0.9" 
#define SERVER_PORT 8080

Serial pc(USBTX, USBRX); // computer to mbed boardSerial esp(D1, D0);
AnalogIn analog_value(A0);
DigitalOut relay(D4);



Thread recvThread;
int power = 0;

char* str_to_char(std::string str){
    std::vector<char> writable(str.begin(), str.end());
    writable.push_back('\0');
    char* ptr = &writable[0];
    
    return ptr;
}

std::string send_data(float level, std::string name){
    MbedJSONValue data_json;
    
    data_json["type"] = "value";
    if(!strcmp(name.c_str(), "waterlevel")){
        data_json["name"] = name;
    } else if(!strcmp(name.c_str(), "humidity"))   {
        data_json["name"] = name;   
    }
    data_json["value"] = level;
 
    return data_json.serialize();
 }
 
 std::string send_ack(int id, std::string type, std::string name, std::string value, std::string tgt_type, int tgt_idx){
    MbedJSONValue ack_json;
               
    ack_json["paired_action_id"] = id;
    ack_json["type"] = type;
    ack_json["name"] = name;
    ack_json["value"] = value;
    ack_json["target"]["type"] = tgt_type;
    ack_json["target"]["index"] = tgt_idx;
    
    return ack_json.serialize();
}

void recv_tcp(TCPSocket* tcp) {
    char recvBuffer[200] = {0, };
    while (1) {
        if (tcp->recv(recvBuffer, sizeof(char) * 200)) {
            
            char value[100] = {0, };
            int idx = 0;
            int tgt_idx = 0;
            sscanf(recvBuffer, "{\"id\":%d,\"type\":\"action\",\"name\":\"power_control\",\"value\":\"%s\",\"target\":{\"type\":\"humidifier\",\"index\":%d}}", &idx, value, &tgt_idx);
             
            if(strstr(value, "on") == value) {
                if(power == 1){
                    pc.printf("power is already on\r\n");
                }
                else{
                    relay.write(0);
                    power = 1;
                    pc.printf("power on\r\n");
                    
                    std::string send_msg = send_ack(idx, "status", "power_state", "on", "humidifier", tgt_idx);
                    pc.printf("send ack: %s\r\n", send_msg.c_str());
                     
                    int scount = tcp->send(str_to_char(send_msg), send_msg.size());
                    pc.printf("length of message : %d\r\n", scount);
                }
                  
            } else if(strstr(value, "off") == value) {
                if(power == 0){
                    pc.printf("power is already off\r\n");
                }
                else{
                    relay.write(1);
                    power = 0;
                    pc.printf("power off\r\n");
                    
                    std::string send_msg = send_ack(idx, "status", "power_state", "off", "humidifier", tgt_idx);
                    pc.printf("send ack: %s\r\n", send_msg.c_str());
                     
                    int scount = tcp->send(str_to_char(send_msg), send_msg.size());
                    pc.printf("length of message : %d\r\n", scount);
                }
            }
            else {
                pc.printf("%s", value);    
            }
        }
    }
}

int main() {

    pc.baud(115200);
    relay.write(1);
    power = 0;
    
    pc.printf("\r\n TCP connection\r\n");
    pc.printf("Resetting ESP8266 Hardware...\r\n");

    wait_ms(500);

    NetworkInterface *network = easy_connect(true);
    
    
    while (1) {        
        TCPSocket socket; // for HTTP
    
        // Open a socket on the network interface, and create a TCP connection
        socket.open(network);
        bool status = socket.connect(SERVER_IP, SERVER_PORT);
  
        if (status == true) {
            recvThread.start(&socket, recv_tcp);
            
            while(1) {
                float meas_lev = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
                meas_lev = meas_lev * 3300; // Change the value to be in the 0 to 3300 range
    
                if(meas_lev <= _threshold){
                   pc.printf("alert!: water level is low\r\n");
                }
                
                pc.printf("Current water level: %.2f\r\n", meas_lev);
                std::string send_msg = send_data(meas_lev, "waterlevel");
                
                pc.printf("send data: %s\r\n", send_msg.c_str());
                int scount = socket.send(str_to_char(send_msg), send_msg.size());
                pc.printf("length of message : %d\r\n", scount);
                
                if(scount == -3012){
                    recvThread.terminate();
                    break;
                }
                
                Thread::wait(3000);
            }
        }    
        socket.close();
    }
}



/*
#include "mbed.h"
 #include "MbedJSONValue.h"
 #include <string>
 
 Serial pc(USBTX, USBRX);
 
 int main() {     
    MbedJSONValue recv_json;
    pc.baud(115200);
    
    char value[64] = {0, };
     
    const  char * json = "{\"id\":0,\"type\":\"action\",\"name\":\"power_control\",\"value\":\"off\",\"target\":{\"type\":\"humidifier\",\"index\":0}}";
    // parse(recv_json, json);
            
    pc.printf("recv %s\r\n", json);
 
    sscanf(json, "{\"id\":0,\"type\":\"action\",\"name\":\"power_control\",\"value\":\"%s\",\"target\":{\"type\":\"humidifier\",\"index\":0}}", value);
    
    if(strstr(value, "on") == value) {
        pc.printf("on found");
    } else if(strstr(value, "off") == value) {
        pc.printf("off found");
    }
    
    return 0; 
 }

*/