/*
#include <string>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

#define SERVER_IP "192.168.0.14"
#define SERVER_PORT 50000

Serial esp(D8, D2); // computer to mbed boardSerial esp(D1, D0);
Serial pc(USBTX, USBRX);

DHT sensor(D6, AM2302);

int main() {
    esp.baud(115200);
    pc.baud(115200);
    pc.printf("\r\n Simple TCP example over ESP8266\r\n\r\n");
    
    pc.printf("\r\nConnecting...\r\n");
    
    NetworkInterface *network = easy_connect(true);
    if (!network) {
        pc.printf("Error: Cannot connect to the network\r\n");
        return -1;
    }

    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());

    TCPSocket socket; // for TCP  
    pc.printf("Sending TCP request to %s : %d ...\r\n", SERVER_IP, SERVER_PORT);
    
    // Open a socket on the network interface, and create a TCP connection
    socket.open(network);
    socket.connect(SERVER_IP, SERVER_PORT);
    
    int err;
    wait(1); // wait 1 second for device stable status
    while (1) {
        err = sensor.readData();
        if (err == 0) {
            //char sbuffer[] = "{\"Temperature\": \"%4.2f C\", \"Humidity\": \"%4.2f\"} \r\n\r\n", sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity();
            char sbuffer[] = "{\"Temperature\": \"22.0 C\", \"Humidity\": \"65 %\"} \r\n\r\n";
            int scount = socket.send(sbuffer, sizeof sbuffer);
            pc.printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
           
            //Receive a simple http response and print out the response line
            char rbuffer[64];
            int rcount = socket.recv(rbuffer, sizeof rbuffer);
            pc.printf("sent %d [%.*s]\r\n", scount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
        } else{
            printf("\r\nErr %i \n",err);
        }
        wait(3);
    }
    
    socket.close();
}
*/

#include <string>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

#define SERVER_IP "192.168.0.14"
#define SERVER_PORT 50000

DHT sensor(D6, AM2302);

Serial pc(USBTX, USBRX); // computer to mbed boardSerial esp(D1, D0);

void http_demo(NetworkInterface *net)
{
    TCPSocket socket; // for HTTP
    
    // Open a socket on the network interface, and create a TCP connection
    socket.open(net);
    socket.connect(SERVER_IP, SERVER_PORT);

    int err;
    wait(1); // wait 1 second for device stable status
    
    err = sensor.readData();
    // Send a simple http request
    if(err == 0){
        char sbuffer[64];
        sprintf(sbuffer, "{\"Temperature\": \"%4.2fC\", \"Humidity\": \"%4.2f %\"} \r\n\r\n", sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity());
        int scount = socket.send(sbuffer, sizeof sbuffer);
        pc.printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
    
        // Recieve a simple http response and print out the response line
        char rbuffer[64];
        int rcount = socket.recv(rbuffer, sizeof rbuffer);
        pc.printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
        
        rcount = socket.recv(rbuffer, sizeof rbuffer);
        pc.printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
    } else {
          char err[] = "Error\r\n";  
          int ecount = socket.send(err, sizeof err);
          pc.printf("sent %d [%.*s]\r\n", ecount, strstr(err, "\r\n")-err, err);
    }
    
    // Close the socket to return its memory and bring down the network interface
    socket.close();
}

int main() {
    pc.baud(115200);
    pc.printf("\r\n Simple HTTP example over ESP8266\r\n\r\n");
    pc.printf("\r\nConnecting...\r\n");

    NetworkInterface *network = easy_connect(true);
    if (!network) {
        pc.printf("Error: Cannot connect to the network\r\n");
        return -1;
    }

    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());
    
    while(1) {
        http_demo(network);
        wait(3);
    }
    
    network->disconnect();
    pc.printf("\r\nDone\r\n");
}