#include <string.h>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

DHT dht22(A0,DHT22);

#define SERVER_IP "192.168.0.8"
#define SERVER_PORT 50000

Serial pc(USBTX, USBRX);



int main(){
    int error = 0;
    pc.baud(115200);
    pc.printf("\r\nConnecting...\r\n");
    NetworkInterface * network = easy_connect(true);
    
    // couldn't find network.
    if(!network)
    {
        pc.printf("Error: Cannot connect to the network\r\n");
       
    }
    //success 
    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());
    
    TCPSocket socket;
    socket.open(network);
    socket.connect(SERVER_IP, SERVER_PORT);

    float cel = 0, humid = 0;
    int send_message, receive_message;
    while(1){
        char rbuffer[64] ={}; 
        pc.printf("Sending request to %s : %d ...\r\n", SERVER_IP, SERVER_PORT);
        // artik to nucleo
        receive_message = socket.recv(rbuffer, sizeof rbuffer);
        pc.printf("%s\r\n", rbuffer);
        if(!strcmp(rbuffer,"GET /DHT22\r\n"))
            {
            char sbuffer[64]={};
            send_message = socket.send("OKAY\r", sizeof("OKAY\r"));
            //
            error = dht22.readData();
            if (error == 0) {
                cel   = dht22.ReadTemperature(CELCIUS);
                humid   = dht22.ReadHumidity();
            }
            else {
                printf("ERROR :  %d\r\n", error);
            }
            sprintf(sbuffer, "TEMP = %.2f humid = %.2f!\r", cel, humid);
            send_message = socket.send(sbuffer, sizeof(sbuffer));
            pc.printf(sbuffer);
        }
        else{
            pc.printf("Unknown request\r");
            send_message = socket.send("Unknown request\r", sizeof("Unknown request\r"));
        }
    }
}