#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;
    


void Blinken(bool left) // Funktion blinken
{
        for (int a = 0; a < 2; a++) // 2 mal
        {
        if (left) // wenn links blinken
        {
            bertl.TurnLedOn(LED_FL2); // schalte vorne linke LED ein
            bertl.TurnLedOn(LED_BL1); // schalte hinten linke LED ein
        }
        else if (!left) // wenn nicht links blinken
        {
           bertl.TurnLedOn(LED_FR2); // schalte vorne rechte LED ein
           bertl.TurnLedOn(LED_BR2); // schalte hinten rechte LED ein
        }
        wait(1); // warte 1 sekunde
        bertl.TurnLedOff(LED_FL2); // schalte vorne linke LED aus
        bertl.TurnLedOff(LED_FR2); // schalte vorne rechte LED aus
        bertl.TurnLedOff(LED_BL1); // schalte hinten linke LED aus
        bertl.TurnLedOff(LED_BR1); // schalte hinten rechte LED aus
        wait(1); // warte 1 sekunde
    }
}

void Fahren()
{
    bertl.Move();
}

void DrehenLinks()
{
    bertl.TurnLeft();
}

void VierRoteLeds(int count)
{
    bertl.NibbleLeds(count);
}

void SchalteLedEin(int16_t led)
{
    bertl.TurnLedOn(led);
}

void SchalteLedAus (int16_t led)
{
    bertl.TurnLedOff(led);
}

void RGBLed(bool red, bool green, bool blue)
{
    bertl.RGBLed(red,green,blue);
}

void BlaueLedsEin()
{
    bertl.BlueLedsON();
}

void BlaueLedsAus()
{
    bertl.BlueLedsOFF();
}

bool WarteBisKnopfGedruckt()
{
    return bertl.WaitUntilButtonPressed();
}

bool VorneFrei()
{
    return bertl.FrontIsClear();
}

bool NebenEinemPieper()
{
    return bertl.NextToABeeper();
}

bool IstDerKnopfGdruckt(const int btn)
{
    return bertl.IsButtonPressed(btn);
}

int GebeGedrucktenKnopfZuruck()
{
    return bertl.ReturnButtonPressed();
}
int main()
{
    Fahren();
    DrehenLinks();
    VierRoteLeds(4);
    SchalteLedEin(LED_FL1);
    wait(1);
    SchalteLedAus(LED_FL1);
    RGBLed(true,false,true);
    BlaueLedsEin();
    BlaueLedsAus();
    
}