/***************************************/
/*                                     */
/*   BRONCODE GROEP 5, MODULE 9, 2014  */
/*       *****-THE SLAP-******         */
/*                                     */
/* -Dominique Clevers                  */
/* -Rianne van Dommelen                */
/* -Daan de Muinck Keizer              */
/* -David den Houting                  */
/* -Marjolein Thijssen                 */
/***************************************/
#include "mbed.h"
#include "HIDScope.h"
#include "arm_math.h"

//Define objects
AnalogIn    emg0(PTB0); //Biceps
AnalogIn    emg1(PTB1); //Triceps
HIDScope scope(2);

arm_biquad_casd_df1_inst_f32 notch;
//constants for 50Hz notch
float notch_const[] = {0.97804894830568079, -0.00000000000000011977645139519872, 0.97804894830568079, 1.0, -0.00000000000000011977645139519872, 0.95609789661136158};
//state values
float notch_states[4];
arm_biquad_casd_df1_inst_f32 highpass;
//constants for 5Hz highpass
float highpass_const[] = {0.802041575714419, -1.604083151428837, 0.802041575714419, 1.0, -1.564503986101199, 0.643662316756476};
//state values
float highpass_states[4];

void looper()
{
    /*variable to store value in*/    
    uint16_t emg_value;
    float filtered_emg;
    float emg_value_f32;
    /*put raw emg value both in red and in emg_value*/
    emg_value = emg0.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32 = emg0.read();

    //process emg
    arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32, &filtered_emg, 1 );
    filtered_emg = fabs(filtered_emg);
    arm_biquad_cascade_df1_f32(&notch, &filtered_emg, &filtered_emg, 1 );
    
    /*send value to PC. */
    scope.set(0,emg_value);     //uint value
    scope.set(1,filtered_emg);  //processed float
    scope.send();

}

int main()
{
    Ticker log_timer;
   //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&notch,1 , notch_const, notch_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const,highpass_states);
    
    log_timer.attach(looper, 0.005);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}