/***************************************/
/*                                     */
/*   BRONCODE GROEP 5, MODULE 9, 2014  */
/*       *****-THE SLAP-******         */
/*                                     */
/* -Dominique Clevers                  */
/* -Rianne van Dommelen                */
/* -Daan de Muinck Keizer              */
/* -David den Houting                  */
/* -Marjolein Thijssen                 */
/***************************************/
#include "mbed.h"
#include "HIDScope.h"
#include "arm_math.h"
 
//Define objects
AnalogIn    emg0(PTB0); //Biceps
AnalogIn    emg1(PTB1); //Triceps
HIDScope scope(5);
 
arm_biquad_casd_df1_inst_f32 notch;
//constants for 50Hz notch
float notch_const[] = {0.9695312529087462, -0.0, 0.9695312529087462, 0.0, -0.9390625058174924};
//state values
float notch_states[4];
arm_biquad_casd_df1_inst_f32 highpass;
//constants for 20Hz highpass
float highpass_const[] = {0.638945525159022, -1.277891050318045, 0.638945525159022, 1.142980502539901, -0.412801598096189};
//state values
float highpass_states[4];
//constants for 80Hz lowpass
arm_biquad_casd_df1_inst_f32 lowpass;
float lowpass_const[] = {0.638945525159022, 1.277891050318045, 0.638945525159022, -1.142980502539901, -0.412801598096189};
//state values
float lowpass_states[4];

 
void looper()
{
    /*variable to store value in*/    
    uint16_t emg_value;
    float emg_value_f32;
    float filtered_emg_notch;
    float filtered_emg_notch_highpass;
    float filtered_emg_notch_highpass_lowpass;
    float filtered_emg_eindsignaal_abs;
    /*put raw emg value both in red and in emg_value*/
    emg_value = emg0.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32 = emg0.read();
 
    //process emg
    arm_biquad_cascade_df1_f32(&notch, &emg_value_f32, &filtered_emg_notch, 1 );
    arm_biquad_cascade_df1_f32(&highpass, &filtered_emg_notch, &filtered_emg_notch_highpass, 1 );
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emg_notch_highpass, &filtered_emg_notch_highpass_lowpass, 1 );
    filtered_emg_eindsignaal_abs = 10*fabs(filtered_emg_notch_highpass_lowpass);
    
    scope.set(0,emg_value_f32);
    scope.set(1,filtered_emg_notch); 
    scope.set(2,filtered_emg_notch_highpass);
    scope.set(3,filtered_emg_notch_highpass_lowpass);
    scope.set(4,filtered_emg_eindsignaal_abs);
    scope.send();
}
 
int main()
{
    Ticker log_timer;
   //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&notch,1 , notch_const, notch_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const,highpass_states);
    arm_biquad_cascade_df1_init_f32(&lowpass,1 ,lowpass_const,lowpass_states);
    
    log_timer.attach(looper, 0.005);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}