/***************************************/
/*                                     */
/*   BRONCODE GROEP 5, MODULE 9, 2014  */
/*       *****-THE SLAP-******         */
/*                                     */
/* -Dominique Clevers                  */
/* -Rianne van Dommelen                */
/* -Daan de Muinck Keizer              */
/* -David den Houting                  */
/* -Marjolein Thijssen                 */
/***************************************/
#include "mbed.h"
#include "HIDScope.h"
#include "arm_math.h"
#define TSAMP 0.005    // sampletijd 200 Hz
 
//Define objects
AnalogIn    emg0(PTB0); //Biceps
AnalogIn    emg1(PTB1); //Triceps
HIDScope scope(4);
int const   windowsamples = 60; //aantal samples waaruit het window voor MOVAG bestaat
 
arm_biquad_casd_df1_inst_f32 notch;
//constants for 50Hz notch
float notch_const[] = {0.9695312529087462, -0.0, 0.9695312529087462, 0.0, -0.9390625058174924};
//state values
float notch_states[4];
arm_biquad_casd_df1_inst_f32 highpass;
//constants for 20Hz highpass
float highpass_const[] = {0.638945525159022, -1.277891050318045, 0.638945525159022, 1.142980502539901, -0.412801598096189};
//state values
float highpass_states[4];
//constants for 80Hz lowpass
arm_biquad_casd_df1_inst_f32 lowpass;
float lowpass_const[] = {0.638945525159022, 1.277891050318045, 0.638945525159022, -1.142980502539901, -0.412801598096189};
//state values
float lowpass_states[4];

//state values looper
    //variable to store value in for biceps
float emg0_value_f32,filtered_emg0_notch,filtered_emg0_notch_highpass,filtered_emg0_notch_highpass_lowpass,filtered_emg0_eindsignaal_abs;
    //variable to store value in for triceps 
float emg1_value_f32,filtered_emg1_notch,filtered_emg1_notch_highpass,filtered_emg1_notch_highpass_lowpass,filtered_emg1_eindsignaal_abs;
    //kalibratiewaardes
float xpos_max,xpos_min,xneg_max,xneg_min;

float emg_biceps [windowsamples];
float emg_triceps [windowsamples];

 
void looper()
{
    /*put raw emg value both in red and in emg_value*/
    emg0_value_f32 = emg0.read();   //?????moet hiet eindsignaal ook bij staan???????
    emg1_value_f32 = emg1.read();
 
    //process emg biceps
    arm_biquad_cascade_df1_f32(&notch, &emg0_value_f32, &filtered_emg0_notch, 1 );
    arm_biquad_cascade_df1_f32(&highpass, &filtered_emg0_notch, &filtered_emg0_notch_highpass, 1 );
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emg0_notch_highpass, &filtered_emg0_notch_highpass_lowpass, 1 );
    filtered_emg0_eindsignaal_abs = 10*fabs(filtered_emg0_notch_highpass_lowpass);  //gelijkrichter
    emg_biceps [0]= filtered_emg0_eindsignaal_abs;
    
    //process emg triceps
    arm_biquad_cascade_df1_f32(&notch, &emg1_value_f32, &filtered_emg1_notch, 1 );
    arm_biquad_cascade_df1_f32(&highpass, &filtered_emg1_notch, &filtered_emg1_notch_highpass, 1 );
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emg1_notch_highpass, &filtered_emg1_notch_highpass_lowpass, 1 );
    filtered_emg1_eindsignaal_abs = 10*fabs(filtered_emg1_notch_highpass_lowpass);  //gelijkrichter
    emg_triceps [0]= filtered_emg1_eindsignaal_abs;

    //Movag
    //Variabelen voor berekenen gemiddelden 
    float avg0,avg1;
    avg0=avg1=0;
    
    //Inhoud van een buffer (=gefilterd signaal) optellen
    for(int x=0; x<windowsamples; x++) {
        avg0 = avg0 + (emg_biceps[x]);
        avg1 = avg1 + (emg_triceps[x]);
    }
    
    //Gemiddelde berekenen en relativeren tov maximum voluntary contraction
    avg0 = avg0/windowsamples/xpos_max;
    avg1 = avg1/windowsamples/xneg_max;
  
    
    //send to PC
    scope.set(0,emg0_value_f32);
    scope.set(1,avg0);
    scope.set(2,emg1_value_f32);
    scope.set(3,avg1);
    scope.send();
}
 
int main()
{
    //referentiewaarden bepalen (kalibreren)
    xpos_max = 0.25;
    xpos_min = 0.1/xpos_max;
    xneg_max = 0.20;
    xneg_min = 0.1/xneg_max;

    //Ticker    
    Ticker log_timer;
    
   //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&notch,1 , notch_const, notch_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const,highpass_states);
    arm_biquad_cascade_df1_init_f32(&lowpass,1 ,lowpass_const,lowpass_states);
    
    log_timer.attach(looper, TSAMP);
    
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}