#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void Bewegen()
{
    bertl.Move();
}

void LinksDrehen()
{
    bertl.TurnLeft();
}

void RoteViererLeds(int value)
{
    bertl.NibbleLeds(value);
}

void LedEinschalten(int16_t led)
{
    bertl.TurnLedOn(led);
}

void LedAusschalten(int16_t led)
{
    bertl.TurnLedOff(led);
}

void RotGruenBlauLed(bool red, bool green, bool blue)
{
    bertl.RGBLed(red, green, blue);
}

void BlaueLedsAusschalten()
{
    bertl.BlueLedsOFF();
}

void BlaueLedsEinschalten()
{
    bertl.BlueLedsON();
}

bool WartBisKnopfGedrueckt()
{
    return bertl.WaitUntilButtonPressed();
}

bool IstVorneFrei()
{
    return bertl.FrontIsClear();   
}

bool NebenEinemPipser()
{
    return bertl.NextToABeeper();   
}

bool IstKnopfGedrueckt(const int btn)
{
    return bertl.IsButtonPressed(btn);
}

int GebeGedruektenKnopfZuruek()
{
    return bertl.ReturnButtonPressed();
}

int main() 
{
    Bewegen();
    LinksDrehen();
    RoteViererLeds(4);
    LedEinschalten(LED_FR1);
    LedAusschalten(LED_FR1);
    RotGruenBlauLed(1, 1, 1);
    BlaueLedsAusschalten();
    BlaueLedsEinschalten();
    WartBisKnopfGedrueckt();
    IstVorneFrei();
    NebenEinemPipser();
    NebenEinemPipser();
    IstKnopfGedrueckt(BTN_BM);
    GebeGedruektenKnopfZuruek();
}
