#include <mbed.h>
//Checkbit-Defines
#define CHECK_BIT(var,pos) ((var) & (1<<(pos))) //Checks if bits are set Input: Variable to chaeck adn the position of the bit to check
//LED-Defines
#define LED_OFF 0x00            // 0b0000 0000, All Leds are off
#define LED_FL_WHITE 0x01       // 0b0000 0001, BERTL FORWARD Left-Side WHITE-LED
#define LED_FL_YELLOW 0x02      // 0b0000 0010, BERTL FORWARD Left-Side YELLOW-LED
#define LED_FR_WHITE 0x04       // 0b0000 0100, BERTL FORWARD Right-Side WHITE-LED
#define LED_FR_YELLOW 0x08      // 0b0000 1000, BERTL FORWARD Right-Side YELLOW-LED
#define LED_BL_RED 0x10         // 0b0001 0000, BERTL BACKWARD Left-Side RED-LED
#define LED_BL_YELLOW 0x20      // 0b0010 0000, BERTL BACKWARD Left-Side YELLOW-LED
#define LED_BR_RED 0x40         // 0b0100 0000, BERTL BACKWARD Right-Side RED-LED
#define LED_BR_YELLOW 0x80      // 0b1000 0000, BERTL BACKWARD Right-Side YELLOW-LED
#define LED_ON 0xFF             // 0b1111 1111, All Leds are on
 
#define LED_R_YELLOW (LED_FR_YELLOW|LED_BR_YELLOW)          // 0b1000 1000, BERTL Right Side, YELLOW-LEDs are on
#define LED_L_YELLOW (LED_FL_YELLOW|LED_BL_YELLOW)          // 0b0010 0010, BERTL Left Side, YELLOW-LEDs are on
#define LED_F_WHITE (LED_FL_WHITE|LED_FR_WHITE)             // 0b0000 0101, BERTL Forward, WHITE-LEDs are on
#define LED_B_RED (LED_BL_RED|LED_BR_RED)                   // 0b0101 0000, BERTL Backward, RED LEDs are on
#define LED_B_ALL (LED_B_RED|LED_BL_YELLOW|LED_BR_YELLOW)   // 0b1111 0000, BERTL Backward, All LEDs are on
#define LED_F_ALL (LED_F_WHITE|LED_FL_YELLOW|LED_FR_YELLOW) // 0b0000 1111, BERTL Forward, All LEDs are on

// Define PC9555 Routines
#define PC9555_ADDR_W 0x40 //A2 = A1 = A0 = 0, WRITE-ADRESS
#define PC9555_ADDR_R 0x41 // READ-ADRESS, to set the Read-bit
#define PC9555_FREQUENCY 100000 // fI2C in Hz

// PC9555 Commands
#define PC9555_PORT0_IN (0)
#define PC9555_PORT1_IN (1)
#define PC9555_PORT0_OUT (2)
#define PC9555_PORT1_OUT (3)
#define PC9555_PORT0_INV (4)
#define PC9555_PORT1_INV (5)
#define PC9555_PORT0_DIRCONFIG (6)
#define PC9555_PORT1_DIRCONFIG (7)

// Define Motor Routines
#define ENGINE_LEFT_BACKWARD P1_0       //IN1, EP10, MG1A => MG1 engine-Pin 2, left_Reverse
#define ENGINE_LEFT_FORWARD P1_1        //IN2, EP11, MG1B => MG1 engine-Pin 1, left_Forward
#define ENGINE_ENABLE_LEFT P1_15        //EN1, P34, left_ENABLE
#define ENGINE_RIGHT_REVERSE P1_4       //IN4, EP13, MG2A => MG2 engine-Pin 2, right_Reverse
#define ENGINE_RIGHT_FORWARD P1_3       //IN3, EP14, MG2B => MG2 engine-Pin 1, right_Forward
#define ENGINE_ENABLE_RIGHT P0_21       //EN2, P36, right_ENABLE
#define MAX_PWM 255                     //Define the MAX Value of the PWM

// Motor Routines
void bertl_engine(int left, int right);
void bertl_engine_test();
 
// PC9555 routines
void bertl_PC9555_init();
void bertl_PC9555_leds(unsigned char leds);
unsigned char bertl_PC9555_switches();

//Checkbit Routines
 bool checkbitFront();
 bool checkbitBack(); 
