/****************************
Bertl engine&I2C Lib. rework 

2.2.2016

by Dominik Sukic
with help from Kevin Heinrich
*****************************/

#include <mbed.h>
#include "bertl.h"
// Define Motor Routines
DigitalOut engineLR(P1_0);      //IN1, EP10, MG1 engine-Pin 2
DigitalOut engineLF(P1_1);      //IN2, EP11, MG1 engine-Pin 1
PwmOut engineLEN(p34);          //EN1, P34
DigitalOut engineRR(P1_4);      //IN4, EP13, MG2 engine-Pin 2
DigitalOut engineRF(P1_3);      //IN3, EP14, MG2 engine-Pin 1
PwmOut engineREN(p36);          //EN2, P36

// Define PC9555 Routines
I2C pc9555(P0_5, P0_4);// SDA, SCL

//Start PC9555 Routines
void bertl_PC9555_init()
{
    char data[2];
    // I2C-Initialisierung
    pc9555.frequency(PC9555_FREQUENCY);
    // Port 0 = Leds, Port 1 = Switches
    // Adresse, R/W# = 0, Config PORT 0 (6) = 0x00(= Output), Stop
    data[0] = PC9555_PORT0_DIRCONFIG;
    data[1] = 0x00;
    pc9555.write(PC9555_ADDR_W, data, 2);
    // Adresse, R/W# = 0, Config PORT 1 (7) = 0xFF(= Input), Stop
    data[0] = PC9555_PORT1_DIRCONFIG;
    data[1] = 0xFF;
    pc9555.write(PC9555_ADDR_W, data, 2);
}

void bertl_PC9555_leds(unsigned char leds)
{
    char data[2];   //Two Bytes for Transmitt via I2C
    // Send leds to PORT0 of PC9555 via I2C:
    // Start, Address, RW# = 0, CMD PC9555_PORT0_OUT, leds, STOP
    data[0] = PC9555_PORT0_OUT;
    data[1] = ~leds;    //bitwise inversion since Hardware is switched on with 0 (inverse logic)
    pc9555.write(PC9555_ADDR_W, data, 2);
}

unsigned char bertl_PC9555_switches()
{
    char taster;

    pc9555.start();                     // Start PC9555 to write the Adress
    pc9555.write(PC9555_ADDR_W);    // Write the WRITE-Adress
    pc9555.write(0x01);             // To define the Switches
    pc9555.start();                     // Start PC9555 again to read the Values
    pc9555.write(PC9555_ADDR_R);    // Set the READ_bit
    taster = pc9555.read(0);        // Read the Value of the Switches
    pc9555.stop();                      // Stop the I2C

    return taster;                    // Return the value

}
// END PC9555 Routines

//Experimental
bool checkbitFront()
{
    bool Frontbuttons = CHECK_BIT(bertl_PC9555_switches(), 7) | CHECK_BIT(bertl_PC9555_switches(), 6) | CHECK_BIT(bertl_PC9555_switches(), 2) | CHECK_BIT(bertl_PC9555_switches(), 0); //Checks if a bit of the front buttons is set

    return Frontbuttons; //returns true if set
}
bool checkbitBack()
{
    bool Backbuttons = CHECK_BIT(bertl_PC9555_switches(), 5) | CHECK_BIT(bertl_PC9555_switches(), 4) | CHECK_BIT(bertl_PC9555_switches(), 1); //Checks if a bit of the back buttons is set

    return Backbuttons; //returns true if set
}

// Begin Motor Routines
void bertl_engine(int left, int right)
{
    // If the left engines-value is greater than 0, the left engine turn FORWARD
    if(left > 0) {
        engineLF=1;
        engineLR=0;
    }
    // Or if the left engines-value is less than 0, the left engine turn REVERSE
    else if(left < 0) {
        engineLF=0;
        engineLR=1;
        left = left * (-1);         // For PWM the Value have to be positive
    }
    // If the right engines-value is greater than 0, the right engine turn FORWARD
    if(right > 0) {
        engineRF=1;
        engineRR=0;
    }
    // Or if the right engines-value is less than 0, the right engine turn REVERSE
    else if(right < 0) {
        engineRF=0;
        engineRR=1;
        right = right * (-1);       // For PWM the Value have to be positive
    }
    // Or if the right- or/and the left engines value equals 0, the ENABLE-Pin turn off
    engineLEN=(left/255.0);
    engineREN=(right/255.0);
}