#include "LCD_DISCO_F429ZI.h"
#include "Led_Lcd.h"


LedLcd::LedLcd (unsigned char _ucColumn)
{
    Column = _ucColumn;
    BSP_LCD_SetFont(&Font24);
    lcd.Clear(LCD_COLOR_BLACK);  
}

void LedLcd::On (unsigned char ucLed_Number)
{
    for ( int i = 0; i < 4; i++ )
    {
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(Column*80,80*i,80,80);
        if ( ucLed_Number == i )
        lcd.SetTextColor(LCD_COLOR_YELLOW);
        else lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.FillRect((1+Column*80),(80*i+1),78,78);
    }
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(Column*80,0, (uint8_t *) "0", LEFT_MODE);
    lcd.DisplayStringAt(Column*80,80, (uint8_t *) "1", LEFT_MODE);
    lcd.DisplayStringAt(Column*80,160, (uint8_t *) "2", LEFT_MODE);
    lcd.DisplayStringAt(Column*80,240, (uint8_t *) "3", LEFT_MODE);
}
