#include "Keyboard_Ts.h"

KeyboardTs::KeyboardTs (unsigned char _ucColumn)
{
    Column = _ucColumn;
}

enum KeyboardTsState KeyboardTs::eRead( void )
{
    ts.GetState(&TS_State);
    x = TS_State.X;
    y = TS_State.Y;
    if (TS_State.TouchDetected)
        {
               if ( ( x > Column*80 ) && ( x <= (Column+1)*80 ) && ( y > 0 ) && ( y < 80 ) )
               {
                    return BUTTON_0;
               } 
               else if ( ( x > Column*80 ) && ( x <= (Column+1)*80 ) && ( y >= 80 ) && ( y < 160 ) )
               {
                    return BUTTON_1;
               }
               else if ( ( x > Column*80 ) && ( x <= (Column+1)*80 ) && ( y >= 160 ) && ( y < 240 ) )
               {
                    return BUTTON_2;
               }
               else if ( ( x > Column*80 ) && ( x <= (Column+1)*80 ) && ( y >= 240 ) && ( y < 320 ) )
               {
                    return BUTTON_3;
               }
        }
    return RELASED;
}
