#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"
#include "TS_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

int main()
{
    BSP_LCD_SetFont(&Font24);
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    lcd.Clear(LCD_COLOR_BLACK);

while(1)
{
    ts.GetState(&TS_State);
    x = TS_State.X;
    y = TS_State.Y;
    for ( int i = 0; i < 4; i++ )
    {
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(0,80*i,80,80);
        if ( (TS_State.TouchDetected) && ( x > 0 ) && ( x <= 80 ) && ( y >= 80*i ) && ( y < 80*( i+1 ) ) )
        lcd.SetTextColor(LCD_COLOR_YELLOW);
        else lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.FillRect(1,(80*i+1),78,78);
    }
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0,0, (uint8_t *) "0", LEFT_MODE);
    lcd.DisplayStringAt(0,80, (uint8_t *) "1", LEFT_MODE);
    lcd.DisplayStringAt(0,160, (uint8_t *) "2", LEFT_MODE);
    lcd.DisplayStringAt(0,240, (uint8_t *) "3", LEFT_MODE);
    wait(0.1);
}
}
