#include "Player.h"

#define WIDTH 10
#define HEIGHT 10

Player::Player(uLCD_4DGL* screenInit, InputHandler* input, int startX, int startY) 
{
    screen = screenInit;
    x = startX;
    y = startY;
    lastX = x-1;
    lastY = y;
    
    inputManager = input;
}

void Player::update(int windowWidth, int windowHeight) 
{
    float xAccel = inputManager->getXAccel() * 4;
    float yAccel = inputManager->getYAccel() * 4;
    
    int speedX = (int)(xAccel + (xAccel > 0 ? 0.5 : -0.5)) ; // Maximum Speed of 4
    int speedY = (int)(yAccel + (yAccel > 0 ? 0.5 : -0.5)) ; // Maximum Speed of 4
    
    x += speedX;
    y += speedY;
    
    // Adjust to be in the window 
    if (x <= WIDTH/2) x = WIDTH/2;
    if (y <= WIDTH/2) y = HEIGHT/2;
    if (x + WIDTH/2 >= windowWidth) x = windowWidth - WIDTH/2;
    if (y + HEIGHT/2 >= windowHeight) y = windowHeight - HEIGHT/2;
}

void Player::draw() 
{
    screen_mutex.lock();
    if (lastX != x || lastY != y) {
        screen->filled_circle(lastX, lastY, HEIGHT, BLACK);
        screen->filled_circle(x, y, HEIGHT/2, GREEN);
    }
    lastX = x;
    lastY = y;
    screen_mutex.unlock();
}

// Bounding Box x
int Player::getX() 
{
    return x - WIDTH/2;
}

int Player::getY() 
{
    return y - HEIGHT/2;
}

int Player::getWidth() 
{
    return WIDTH;
}

int Player::getHeight() 
{
    return HEIGHT;
}
        