#include "InputHandler.h"

#define START_THREAD 1

InputHandler::InputHandler(PinName sda, PinName scl, uint8_t xgAddr, uint8_t mAddr, PinName digitalIn)
    :imu(sda, scl, xgAddr, mAddr),
     pushButton(digitalIn, PullUp)
{
    imu.begin();
//    imu.calibrate(1);
}

Thread* InputHandler::start() {
    return new Thread(&InputHandler::threadStarter, this, osPriorityNormal,1024);
}

float InputHandler::getXAccel() {
    stdio_mutex.lock();
    float temp = xAccel;
    stdio_mutex.unlock();
    return temp;
}

float InputHandler::getYAccel() {
    stdio_mutex.lock();
    float temp = yAccel;
    stdio_mutex.unlock();
    return temp;
}

float InputHandler::getZAccel() {
    stdio_mutex.lock();
    float temp = zAccel;
    stdio_mutex.unlock();
    return temp;
}

bool InputHandler::getPushed() { 
    stdio_mutex.lock();
    float temp = isPushed;
    stdio_mutex.unlock();
    return temp;
}

void InputHandler::threadStarter(void const *p) {
  InputHandler *instance = (InputHandler*)p;
  instance->retrieveInputs();
}
        
void InputHandler::retrieveInputs() {
    
    while(true) {
        imu.readAccel();
         
        stdio_mutex.lock();
        xAccel = -imu.calcAccel(imu.ax);
        yAccel = -imu.calcAccel(imu.ay);     
        zAccel = -imu.calcAccel(imu.az);
        isPushed = pushButton.read() == 0;
        //printf("\t\txAccel: %.6f\n\ryAccel: %.6f\n\risPushed: %s", xAccel, yAccel, isPushed ? "true" : "false");
        stdio_mutex.unlock();
        
        Thread::wait(30); 
    } 
}