#ifndef _Invader_H_
#define _Invader_H_

#include "rtos.h"
#include "uLCD_4DGL.h"

class Invader 
{
    public:
        // Constructors
        Invader(uLCD_4DGL* screen, int width, int height);
        
        // Game function
        void update();
        void draw();
        
        // Intersection
        bool intersects(int otherX, int otherY, int otherWidth, int otherHeight);
        
        // Getters
        //int getX();
//        int getY();
//        int getWidth();
//        int getHeight();
        
    private:
        Mutex screen_mutex;
        uLCD_4DGL* screen;
        
        void resetLocationAndSpeed();
        
        int windowHeight;
        int windowWidth;
        
        int x;
        int y;
        int lastX;
        int lastY;
        int spdX;
        int spdY;
};

#endif