#ifndef _InputHandler_H_
#define _InputHandler_H_

#include "LSM9DS1.h"
#include "mbed.h"
#include "rtos.h"

class InputHandler
{
    public:
        InputHandler(PinName sda, PinName scl, uint8_t xgAddr, uint8_t mAddr, PinName dio);
    
        float getXAccel();
        float getYAccel();
        float getZAccel();
        bool  getPushed();
        
        Thread* start();
    
    private:
        static void threadStarter(void const *p);
        void retrieveInputs();
        
        LSM9DS1 imu;
        DigitalIn pushButton;
        float xAccel;
        float yAccel;
        float zAccel;
        bool isPushed;
        
        Mutex stdio_mutex;
};        

#endif