#include "mbed.h"
#include "InputHandler.h"
#include "Invader.h"
#include "Player.h"
#include "SDFileSystem.h"

#include <wave_player.h>
#include <vector>

#define SIGNAL_KILL 200

#define WIDTH 128
#define HEIGHT 128

#define NUM_INVADERS 2

DigitalOut led(LED1);

AnalogOut DACout(p18);
 SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

void updatePlayer(const void* player) {
    while(true) {
        Player *p = (Player*)player;
        p->update(WIDTH, HEIGHT);
        Thread::wait(45);
    }
}

void updateInvader(const void* invaders) {
    std::vector<Invader*> invaderVector = *((std::vector<Invader*>*)invaders);
    while(true) {
        for (std::vector<Invader*>::iterator it = invaderVector.begin(); it != invaderVector.end(); ++it) {
            (*it)->update();
        }
        Thread::wait(45);  
    }
}

FILE *wave_file;
    
void playBackgroundMusic(const void* waver) {
    wave_player* playMe = (wave_player*)waver;
    playMe->play(wave_file);
    Thread::wait(50);
}

int main() {
    InputHandler input(p9, p10, 0xD6, 0x3C, p15);
    uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
    
    wave_player waver(&DACout);
    wave_file=fopen("/sd/beethoven.wav","r");
    
    Thread* inputThread = input.start();
    uLCD.background_color(BLACK);
    uLCD.baudrate(300000);

    bool alive = false;
    while(true) {
        uLCD.media_init();
        uLCD.set_sector_address(0x003B, 0x5001);
        uLCD.display_image(0,0);
        while(!input.getPushed()) {}
        
        Player player(&uLCD, &input, WIDTH/2, HEIGHT/2);
    
        std::vector<Invader *> invaders;
        for (int i = 0; i < NUM_INVADERS; i++) {
            invaders.push_back(new Invader(&uLCD, WIDTH, HEIGHT));
        }
        
        alive = true;
        uLCD.cls();
        uLCD.background_color(BLACK);
        
        // Start the music and the two updater threads (different speeds)
        Thread* playerThread = new Thread(updatePlayer, &player);
        Thread* invaderThread = new Thread(updateInvader, &invaders);
        Thread* wavplayerThread = new Thread(playBackgroundMusic, &waver);
        
        while (alive) {
            player.draw();
            int count = 1;
            for (std::vector<Invader*>::iterator it = invaders.begin(); it != invaders.end(); ++it) {
                 printf("count: %d", count);
                 (*it)->draw();
                  alive = !(*it)->intersects(player.getX(), player.getY(), player.getWidth(), player.getHeight());
                  led = alive;
                  count++;
            }
            wait_ms(40);
        }
        uLCD.locate(2, 2);
        uLCD.printf("GAME OVER! >:)");
        
        playerThread->terminate();
        invaderThread->terminate();
        wait_ms(5000);
        break;
    }
}
