#ifndef _Human_H_
#define _Human_H_

#include "rtos.h"
#include "uLCD_4DGL.h"
#include "InputHandler.h"

class Player {
    public:
        Player(uLCD_4DGL* screen, InputHandler* input, int startX, int startY);
        
        // Game function
        void update(int windowWidth, int windowHeight);
        void draw();
        
        // Get coordinates
        int getX();
        int getY();
        int getWidth();
        int getHeight();
        
    private:
        uLCD_4DGL* screen;
        Mutex screen_mutex;
        InputHandler* inputManager;
        
        int x;
        int y;
        int lastX;
        int lastY;
};

#endif