#include "mbed.h"
#include "Motor.h"
#include "Servo.h"
/************************************* Lab5 Motor to servo  **********************************/
/*                                                                                           */
/*  File: main.cpp                                                                           */
/*  Author: Ziad Eldebri                                                                     */
/*  Date Created: 9/19/2016                                                                  */
/*  Description:                                                                             */
/*  Edit: Matthew Sessions                                                                   */
/*                                                                                           */
/*********************************************************************************************/

Servo my_servo(PTB3,PTE19,PTE18,PTE31);
AnalogIn Spanel(PTB2);
//uint16_t reading_array[3];
const uint16_t max_degree = 120;
const uint16_t size=20;
unsigned int reading_array[size];
//unsigned int reading_array[size]; 
unsigned int position_array[size];  
unsigned int largest = 0; 
//unsigned int largest = 0;
unsigned int largesti = 0;
unsigned int i;

//Serial pc(USBTX, USBRX);

int main() 
{

    for (i=0; i<size;i++)
    {

       position_array[i] = i*max_degree/size +20 ;

    }

    while (1) 
    {  
        for (i = 0; i < size; i++)
        {

            //set position
            my_servo.set(position_array[i]);
            
            //pc.printf(" Reading array %d %ld\n  ", i , reading_array[i]);
            
            //check position    

            while(1)
            {
                //one but not both, XOR
                if((my_servo.get()-position_array[i] > -25 ) ^ (my_servo.get()  - position_array[i]  <25))
                {

                     break;
                }

                else
                {
                        my_servo.set(position_array[i]);
                        wait(.2);
                }


            }

            //write analog values (integers) to array
            reading_array[i] = Spanel.read_u16()*100;
        }



        for (i = 0; i < size; i++)
        {
            if (reading_array[i] > largest)
            {

                largest = reading_array[i];
                largesti = i;

            }

        }

        //pc.printf(" servo pos %d %ld\n ", 0 , my_servo.get());
        //pc.printf(" Largest degree %d %ld\n ", position_array[largesti], reading_array[largesti]);  
        my_servo.set(position_array[largesti]);

        wait(8);

    }
}