#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                                      MSB
//        2^0   2^1   2^2                                          2^11
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
//        D20   D19   D18  D17  D16  D15  D14  D13  D4   D3   D2   D1

// Zustandsangebe
BusOut stLED(P1_13,P1_12);

//        Sw3    Sw4
BtnEventM0 sw3(P0_23), sw4(P1_16); //sw4 ist Fußgängerknopf

Serial pc (USBTX, USBRX);

class Ampel {
    public:
        void Init();
        void rot_func();
        void gelb_func();
        void gruen_func();
        void gruen_blink_func();
    private:
        void rot_act();
        void gelb_act();
        void gruen_act();
        void gruen_blink_act();
    public:
        Timer t1, t2, t3;
        int state;
};

const int st_rot = 1;
const int st_gelb = 2;
const int st_gruen = 3;
const int st_gruen_blink = 4;

Ampel amp;

main() {
    while(1) {
        if(amp.state == 1)
            amp.rot_func();
        if(amp.state == 2)
            amp.gelb_func();
        if(amp.state == 3)
            amp.gruen_func();
        if(amp.state == 4)
            amp.gruen_blink_func();
    }
}

void Ampel::Init() {
    t1.start();
    t2.start();
    t3.start();
    
    state = st_rot;
}

void Ampel::rot_func() {
    stLED = 1;
    
    while(1) {
        rot_act();
        
        if(t1.read_ms()>3000) {
            t1.reset();
            state = st_gelb;
            return;
        }
    }
}

void Ampel::gelb_func() {
    stLED = 2;
    
    while(1) {
        gelb_act();
        
        if(t1.read_ms()>4000) {
            t1.reset();
            state = st_gruen;
            return;
        }
        if(sw4.CheckFlag()) {
            state = st_gruen_blink;
            return;
        }
    }
}

void Ampel::gruen_func() {
    stLED = 3;
    
    while(1) {
        gruen_act();
        
        if(t1.read_ms()>5000) {
            t1.reset();
            state = st_rot;
            return;
        }
        if(sw4.CheckFlag()) {
            state = st_gruen_blink;
            return;
        }
    }
}

void Ampel::gruen_blink_func() {
    stLED = 4;
    
    while(1) {
        gruen_blink_act();
        
        if(t1.read_ms()>2000) {
            t1.reset();
            state = st_rot;
            return;
        }
    }
}

void Ampel::rot_act() {
    if(t2.read_ms()>100) {
        if(lb = 0)
            lb = 2;
        else
            lb = 0;
    }
}

void Ampel::gelb_act() {
    if(t2.read_ms()>200) {
        if(lb = 0)
            lb = 4;
        else
            lb = 0;
    }
}

void Ampel::gruen_act() {
    if(t2.read_ms()>500) {
        if(lb = 0)
            lb = 8;
        else
            lb = 0;
    }
}

void Ampel::gruen_blink_act() {
    if(t2.read_ms()>700) {
        if(lb = 0)
            lb = 16;
        else
            lb = 0;
    }
}