#include "mbed.h"
#include "BtnEventM0.h"

Serial pc(USBTX, USBRX);
//        LSB                                                      MSB
BusOut lb(/*P1_13,P1_12,P1_7,*/P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

BtnEventM0 sw4(P1_16), sw3(P0_23), sw1(P0_10), sw2(P0_15);

// Zustandsangebe
BusOut stLED(P1_13,P1_12,P1_7);


const int st_run = 1;
const int st_editH = 2;
const int st_editM = 3;
const int st_editalarmH = 4;
const int st_editalarmM = 5;

int blinkIdx = 0;
int hh=0, mm=0;
int alarmhh=0, alarmmm=0;
bool alarm = false;


class Timmer
{
public:
    void Init();
    void Run();
    void EditH();
    void EditM();
    void EditalarmH();
    void EditalarmM();
public:
    int state;
private:
    Timer t1;
};

Timmer tim1;

int main()
{
    pc.baud(500000);
    sw4.Init();         // Switch state
    sw3.Init();         // Count UP
    sw1.Init();         // Count DOWN
    sw2.Init();         // Set Alarm
    tim1.Init();

    while(1) {
        if(tim1.state == st_run) {
            tim1.Run();
            blinkIdx = 0;
        }
        if(tim1.state == st_editH) {
            tim1.EditH();
            blinkIdx = 3;
        }
        if(tim1.state == st_editM) {
            tim1.EditM();
            blinkIdx = -1;
        }
        if(tim1.state == st_editalarmH) {
            tim1.EditalarmH();
            blinkIdx = 3;
        }
        if(tim1.state == st_editalarmM) {
            tim1.EditalarmM();
            blinkIdx = -1;
        }
    }
}

void Timmer::Init()
{
    state= st_run;
    t1.start();
}

void Timmer::Run()
{
    // 1..in die erste Zeile schreiben
    pc.printf("1 Clock running\n");
    pc.printf("3 %d\n", blinkIdx);
    stLED = 1;

    while(1) {
        if(sw4.CheckFlag()) {
            state = st_editH;
            return;
        }
        if(sw2.CheckFlag()) {
            state = st_editalarmH;
            alarm = true;
            return;
        }

        if(t1.read_ms() > 50) {        // Ausgabe mit 20Hz,aber dafür hate 1h 60min!!!
            t1.reset();
            mm++;
            if(mm > 59) {
                mm = 0;
                hh++;
            }
            if(hh > 23) {
                hh = 0;
            }

            // Alram
            if(alarm == true) {
                if(hh == alarmhh && mm == alarmmm) {
                    pc.printf("1 !!!ALARM!!!\n");
                    alarmhh=0;
                    alarmmm=0;
                    alarm = false;
                }
            }
            // Disable alarm
            if(sw3.CheckFlag() && sw1.CheckFlag()) {
                pc.printf("1 Clock running\n");
            }
            pc.printf("2 %02d:%02d\n",hh,mm);
        }
    }
}

/*********** SET TIME **************/

void Timmer::EditH()
{
    pc.printf("1 Edit hh\n");
    pc.printf("2 %02d:%02d\n", hh, mm);
    pc.printf("3 %d\n", blinkIdx);
    stLED = 2;

    while(1) {
        if(sw4.CheckFlag()) {
            state = st_editM;
            return;
        }

        // Count UP
        if(sw3.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            hh++;
            if(hh > 23)
                hh = 0;
            pc.printf("2 %02d:%02d\n", hh, mm);

            wait_ms(300);
            if(sw3.CheckButton())
                while(sw3.CheckButton()) {
                    // ContinousPress erkannt
                    hh++;
                    if(hh > 23)
                        hh = 0;
                    pc.printf("2 %02d:%02d\n", hh, mm);
                    wait_ms(100);
                }
        }

        // Count DOWN
        if(sw1.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            hh--;
            if(hh < 0)
                hh = 23;
            pc.printf("2 %02d:%02d\n", hh, mm);

            wait_ms(300);
            if(sw1.CheckButton())
                while(sw1.CheckButton()) {
                    // ContinousPress erkannt
                    hh--;
                    if(hh < 0)
                        hh = 23;
                    pc.printf("2 %02d:%02d\n", hh, mm);
                    wait_ms(100);
                }
        }
    }
}

void Timmer::EditM()
{
    pc.printf("1 Edit mm\n");
    pc.printf("2 %02d:%02d\n", hh, mm);
    pc.printf("3 %d\n", blinkIdx);
    stLED = 3;

    while(1) {
        if(sw4.CheckFlag()) {
            state = st_run;
            return;
        }

        // Count UP
        if(sw3.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            mm++;
            if(mm > 59 )
                mm = 0;
            pc.printf("2 %02d:%02d\n", hh, mm);

            wait_ms(300);
            if(sw3.CheckButton())
                while(sw3.CheckButton()) {
                    // ContinousPress erkannt
                    mm++;
                    if(mm > 59)
                        mm = 0;
                    pc.printf("2 %02d:%02d\n", hh, mm);
                    wait_ms(100);
                }
        }

        // Count DOWN
        if(sw1.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            mm--;
            if(mm < 0)
                mm = 59;
            pc.printf("2 %02d:%02d\n", hh, mm);

            wait_ms(300);
            if(sw1.CheckButton())
                while(sw1.CheckButton()) {
                    // ContinousPress erkannt
                    mm--;
                    if(mm < 0)
                        mm = 59;
                    pc.printf("2 %02d:%02d\n", hh, mm);
                    wait_ms(100);
                }
        }
    }
}

/*********** SET ALARM **************/

void Timmer::EditalarmH()
{
    pc.printf("1 Edit alarm hh\n");
    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
    pc.printf("3 %d\n", blinkIdx);
    stLED = 4;

    while(1) {
        if(sw2.CheckFlag()) {
            state = st_editalarmM;
            return;
        }

        // Count UP
        if(sw3.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            alarmhh++;
            if(alarmhh > 23)
                alarmhh = 0;
            pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);

            wait_ms(300);
            if(sw3.CheckButton())
                while(sw3.CheckButton()) {
                    // ContinousPress erkannt
                    alarmhh++;
                    if(alarmhh > 23)
                        alarmhh = 0;
                    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
                    wait_ms(100);
                }
        }

        // Count DOWN
        if(sw1.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            alarmhh--;
            if(alarmhh < 0)
                alarmhh = 23;
            pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);

            wait_ms(300);
            if(sw1.CheckButton())
                while(sw1.CheckButton()) {
                    // ContinousPress erkannt
                    alarmhh--;
                    if(alarmhh < 0)
                        alarmhh = 23;
                    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
                    wait_ms(100);
                }
        }
    }
}

void Timmer::EditalarmM()
{
    pc.printf("1 Edit alarm mm\n");
    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
    pc.printf("3 %d\n", blinkIdx);
    stLED = 5;

    while(1) {
        if(sw2.CheckFlag()) {
            state = st_run;
            return;
        }

        // Count UP
        if(sw3.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            alarmmm++;
            if(alarmmm > 59 )
                alarmmm = 0;
            pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);

            wait_ms(300);
            if(sw3.CheckButton())
                while(sw3.CheckButton()) {
                    // ContinousPress erkannt
                    alarmmm++;
                    if(alarmmm > 59)
                        alarmmm = 0;
                    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
                    wait_ms(100);
                }
        }

        // Count DOWN
        if(sw1.CheckFlag()) {
            // Aktion für EinfachClick z.B. cnt++ ausführen
            alarmmm--;
            if(alarmmm < 0)
                alarmmm = 59;
            pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);

            wait_ms(300);
            if(sw1.CheckButton())
                while(sw1.CheckButton()) {
                    // ContinousPress erkannt
                    alarmmm--;
                    if(alarmmm < 0)
                        alarmmm = 59;
                    pc.printf("2 %02d:%02d\n", alarmhh, alarmmm);
                    wait_ms(100);
                }
        }
    }
}