/**
* example MMA8491Q accelerometer on Sensor Evaluation Board
* with the FRDM-KL25Z processor board
*/
#include "mbed.h"
#include "MMA8491Q.h"
 
#define MMA8451_I2C_ADDRESS (0x55<<1)

Serial pc(USBTX, USBRX);
 
int main(void) {
 
    MMA8491Q acc(PTE0, PTE1, MMA8451_I2C_ADDRESS, PTA13);
    
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    
    float accX;
    float accY;
    float accZ;
    float accData[3];

    while (true) {       
   /*     acc.getAccAllAxis(accData);
        accX = accData[0];
        accY = accData[1];
        accZ = accData[2];
   */     
        accX = acc.getAccX();
        accY = acc.getAccY();
        accZ = acc.getAccZ();
        
  /*      rled = 1.0 - abs(accX);
        gled = 1.0 - abs(accX);
        bled = 1.0 - abs(accX);
*/
        pc.printf("X = %5.3f", accX);
        pc.printf("  Y = %5.3f", accY);
        pc.printf("  Z = %5.3f\r\n", accZ);
 
        wait(1.0);
   }
}
