#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "globals.h"

#include "drawMe.h"
#include "pixelRun.h"
#include "TempSense.h"

void showButton(uint32_t, uint32_t, int, uint8_t *);

uint16_t butHeight = 80;
uint16_t butWidth = 80;

//LCD_DISCO_F746NG LCDscreen;
//TS_DISCO_F746NG LCDtouchScreen;

int main()
{
//init LCD screen
TS_StateTypeDef touchStatus;
LCDtouchScreen.Init(LCDscreen.GetXSize(), LCDscreen.GetYSize());

    //set button text
    uint8_t but1Text[30] = " Draw Game";
    uint8_t but2Text[30] = " Pixel Run";
    uint8_t but3Text[30] = "Temperature";

    //set background to black
    LCDscreen.Clear(LCD_COLOR_BLACK);

    //draw buttons
    showButton(LCD_COLOR_BLUE, LCD_COLOR_WHITE, 1, but1Text);           //draw
    showButton(LCD_COLOR_GREEN, LCD_COLOR_WHITE, 2, but2Text);          //pixel
    showButton(LCD_COLOR_YELLOW, LCD_COLOR_WHITE, 3, but3Text);         //temperature

    //loop that checks for button presses
    while(1) {
        LCDtouchScreen.GetState(&touchStatus);
        if (touchStatus.touchDetected) {
            if ((touchStatus.touchX[0] <= 80)  && (touchStatus.touchY[0] <= 80)) {
                drawGame();
            } else if ((touchStatus.touchX[0] <= 80) && (touchStatus.touchY[0] <= 160)) {
                pixelScan();
            } else if ((touchStatus.touchX[0] <= 80) && (touchStatus.touchY[0] <= 240)){
               tempDisplay();
            }
        }
    }
}

void showButton(uint32_t backColor, uint32_t textColor, int position, uint8_t *text)
{
    LCDscreen.SetBackColor(backColor);
    LCDscreen.SetTextColor(backColor);
    LCDscreen.SetFont(&Font12);

    if (position == 1) {
        LCDscreen.FillRect(0, 0, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(0, 40, text, LEFT_MODE);
    } else if (position == 2) {
        LCDscreen.FillRect(0, 80, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(0, 120, text, LEFT_MODE);
    } else if (position == 3) {
        LCDscreen.FillRect(0, 160, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(0, 200, text, LEFT_MODE);
    } else if (position == 4) {
        LCDscreen.FillRect(80, 0, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(80, 40, text, LEFT_MODE);
    } else if (position == 5) {
        LCDscreen.FillRect(80, 80, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(80, 120, text, LEFT_MODE);
    } else if (position == 6) {
        LCDscreen.FillRect(80, 160, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(80, 200, text, LEFT_MODE);
    } else if (position == 7) {
        LCDscreen.FillRect(160, 0, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(160, 40, text, LEFT_MODE);
    } else if (position == 8) {
        LCDscreen.FillRect(160, 80, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(160, 120, text, LEFT_MODE);
    } else if (position == 9) {
        LCDscreen.FillRect(160, 160, butWidth, butHeight);
        LCDscreen.SetTextColor(textColor);
        LCDscreen.DisplayStringAt(160, 200, text, LEFT_MODE);
    }
}