#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"
#include "encoder.h"

DigitalOut gpo(D0);
DigitalOut motorDirection(D4);
PwmOut motorSpeed(D5);
AnalogIn potMeterIn1(A1);
AnalogIn potMeterIn2(A2);
//InterruptIn button1(D3);
Ticker m1_Ticker;
Encoder encoder1(D13,D12);
const double M1_KP = 2.5, M1_KI = 1.0;
const double M1_TS = 0.01;
const double RAD_PER_PULSE = 0.002991;
double m1_err_int = 0;
int motorD = 0;
double motor1 = 0;

MODSERIAL pc(USBTX, USBRX);


                                                                                    // Reusable PI controller
double PI( double e, const double Kp, const double Ki, double Ts, double &e_int ){
    e_int += Ts ∗ e;                                                                // e_int is changed globally because it’s ’by reference’ (&)
    return Kp ∗ e + Ki ∗ e_int;
}
                                                                                    // Next task, measure the error and apply the output to the plant
void m1_Controller() {
    double reference = potMeterIn1;
    
    
    double position = RAD_PER_PULSE∗encoder1;                         // Don’t use magic numbers!
    motor1 = PI( reference − position, M1_KP, M1_KI, M1_TS, m1_err_int );
    if ( reference − position >= 0) 
        {
            //float motor1DirectionPin1 = 1;
            motorD=1;
        }
        else
        {
            //float motor1DirectionPin1 = 0;
            motorD=0;
        }
}

int main() {
    m1_Ticker.attach( &m1_Controller, M1_TS );                                      // 100 Hz
    while( 1 ) {
        motorDirection.write(motorD);
        motorSpeed.write(motor1);        
    }
}
}
    