#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"

DigitalOut Ledr(LED_RED);
DigitalOut Ledg(LED_GREEN);
DigitalOut Ledb(LED_BLUE);
PwmOut motorSpeed(D13);
PwmOut motorSpeed2(D12);
InterruptIn Button1(PTC6);
Ticker tick;


enum states{Close, Open};

states CurrentState = Open;

int i = 0;
int j = 0;

void Change()
{
    if(CurrentState == Close){
    CurrentState = Open;
    } 
    else{
    CurrentState = Close;
    }
}



void ProcessStateMachine(void)
{
    switch (CurrentState)
        {        
        case Close:
            if(j <= 34){
                motorSpeed.write(0);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 35){
                motorSpeed.write(1);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 36){
                motorSpeed.write(1);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 37){
                motorSpeed.write(1);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 38){
                motorSpeed.write(1);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 39){
                motorSpeed.write(1);
                motorSpeed2.write(1);
                j = 0;
            }
            Ledr = 0;
            Ledg = 1;
            Ledb = 1;
        break;
        
        case Open:
            if(j <= 34){
                motorSpeed.write(0);
                motorSpeed2.write(0);
                j++;
            }
            else if (j == 35){
                motorSpeed.write(0);
                motorSpeed2.write(1);
                j++;
            }
            else if (j == 36){
                motorSpeed.write(0);
                motorSpeed2.write(1);
                j++;
            }
            else if (j == 37){
                motorSpeed.write(0);
                motorSpeed2.write(1);
                j++;
            }
            else if (j == 38){
                motorSpeed.write(0);
                motorSpeed2.write(1);
                j++;
            }
            else if (j == 39){
                motorSpeed.write(1);
                motorSpeed2.write(1);
                j = 0;
            }
            Ledr = 1;
            Ledg = 1;
            Ledb = 0;
        break;
        
        default:
            Ledr = 1;
            Ledg = 0;
            Ledb = 1;
    }
}



int main() {
    tick.attach(ProcessStateMachine, 0.0005);
    Ledr = 1;
    Ledg = 1;
    Ledb = 1;
        
    while (true)
    {
        Button1.rise(&Change);
    }
}  