#include "mbed.h"

#ifndef FINITESTATEMACHINE_H
#define FINITESTATEMACHINE_H

#define LED(i) led##i

typedef enum {BlinkLed = 0,BlinkTwoLed,PrintMenu,BlinkAll} State_Type;

void InitializeSystem();
void Task1();
void Task2();
void Task3();
void Task4();
void blinker();

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

BusOut leds(LED1,LED2,LED3,LED4);


//pointer to function to call each state
void(*state_table[])() = {Task1,Task2,Task3,Task4};

State_Type curr_state;

volatile int i;

void InitializeSystem(){
   void Task1();

}

void Task1(){
curr_state = BlinkLed;
    
    blinker();

    led1=0;
    wait(0.5);
    curr_state =  BlinkTwoLed;
}

void Task2(){
    curr_state =  BlinkTwoLed;

    for(i=0;i<4;i++){
     led2=1;
     led3=0;
     wait(0.5);
     led2=0;
     led3=1;
     wait(0.5);
    }
    led2=0;
    led3=0;
    wait(1);
    
    curr_state =  PrintMenu;
}
void Task3(){
    curr_state =  PrintMenu;
    printf("1. Select task. \n\r2. Press Button.\n\r3. Enjoy.\n\r");
    wait(0.5);
    for(int k=0;k<4;k++){
        printf("Boom\n\r");
        }
    curr_state = BlinkAll;
    
}
void Task4(){
    curr_state =  BlinkAll;
  for(int j=0;j<4;j++){
     for(int i=0; i<4; i++) {
            leds = 1 << i;
            wait(0.25);
         }   
        leds=0;
    
    }
    
    wait(1);
    curr_state = BlinkLed;
}

void blinker(){        
    
  for(int j=0;j<4;j++) { 
	led1 = 1;
	wait(0.5);
	led1 = 0;
	wait(0.2);
}

    /*led1 = 1; //loop unrolling 
    wait(1);
    led1 = 0;
    wait(1);
    led1 = 1;
    wait(1);
    led1 = 0;
    wait(1);
    led1 = 1;
    wait(1);
    led1 = 0;*/

}
              
#endif
