#include "MAX30101.h"
 #include "mbed.h"


MAX30101::MAX30101(PinName sda, PinName scl) : m_i2c(sda, scl){
   // mode (HR, SpO2, or multi-led)
   mode = modeMultiLED;

    m_addr = MAX30101_I2C_ADDRESS;
   // LED currents
   LEDCurrentRed = 0;
   LEDCurrentIR = 0;
   LEDCurrentGreen = 0;

   // timings
   sampleRate = sampleRate_50;
   pulseWidth = ledPower_411;
   // ADC range
   range = adcRange8192;
   // averaging
   oversample = ovsNone;
  
//   writeRegister(MAX30101_LED1RedPulseAmplitude,   0xFF );
//   writeRegister(MAX30101_LED2IrPulseAmplitude,    0x33 );
//   writeRegister(MAX30101_LED3GreenPulseAmplitude, 0xFF );
//   writeRegister(MAX30101_ProximityModePulseAmplitude,  0x19 );
//
//   writeRegister( MAX30101_MultiLEDModeControlTime2Time1, 0x03 );
//   writeRegister( MAX30101_MultiLEDModeControlTime4Time3, 0x00 );
//
//   writeRegister( MAX30101_FIFOConfiguration , 0x06 );
//   writeRegister( MAX30101_SPO2Configuration , 0x43 );

   writeRegister(MAX30101_ProximityInterruptThreshold , 0x14 );

   /** clear FIFO pointers */
   writeRegister(MAX30101_FIFO_WR_PTR , 0 );
   writeRegister(MAX30101_FIFO_RD_PTR , 0 );
   writeRegister(MAX30101_FIFO_OV_PTR , 0 );

}
 
MAX30101::~MAX30101() { }

    
 void MAX30101::enable(void)
 {
   
   writeRegister( MAX30101_InterruptEnable1 , 0x10 );
   writeRegister( MAX30101_ModeConfiguration , 0x07 ); 
      
 }
    
 void MAX30101::shutdown(void)
 {
   writeRegister(MAX30101_ModeConfiguration,SHDN);
      
 }
 
  max30101_status_t MAX30101::reset(void)
 {
    writeRegister(MAX30101_ModeConfiguration,RESET);
    
    while (1)
    {
    uint8_t status = readRegister( MAX30101_ModeConfiguration );

      if ( 0 == ( status & RESET ) )
      {
        return STATUS_MAXIM_SUCCESS;
      }
    }
   
 }
 
 void MAX30101::setMode(max30101_mode_t sensorMode)
 {
     
 }
 
 void MAX30101::setSPO2_ADC_range(void)
 {

   
 }

 
 void MAX30101::set_SPO2_sampleRange(void)
 {

 }
    
 void MAX30101::set_LED_PulseWidth(uint8_t pw)
 {
    
 }
 
 max30101_status_t MAX30101::readRawData(uint8_t* dataBuff, uint8_t* sampleNum )
 {
     // temporary buffer to read samples from the FIFO buffer
    uint8_t  tmpBuf[ MAXIM_FIFO_DEPTH * MAXIM_BYTES_PER_ADC_VALUE ];

    uint8_t  numAvailSam;

    // read FIFO pointers
    uint8_t fifoWrPtr = readRegister( MAX30101_FIFO_WR_PTR );
    uint8_t fifoRdPtr = readRegister( MAX30101_FIFO_RD_PTR );
    uint8_t fifoOvPtr = readRegister( MAX30101_FIFO_OV_PTR );
    
    // overflow happened
    if ( fifoOvPtr > 0 )
    {
      uint8_t      cmd = MAX30101_FIFO_DATA ;
      readRegs(cmd,tmpBuf,100);
      numAvailSam = 0xFF;
    }

    else
    {
        if ( fifoWrPtr > fifoRdPtr )
        {
            /**
            * NUM_AVAILABLE_SAMPLES = FIFO_WR_PTR – FIFO_RD_PTR
            * NUM_SAMPLES_TO_READ   = < less than or equal to NUM_AVAILABLE_SAMPLES >
            */
            numAvailSam = fifoWrPtr - fifoRdPtr;
        }

        // note: pointer wrap around should be taken into account
        else if ( fifoWrPtr < fifoRdPtr )
        {
            numAvailSam = fifoWrPtr + MAXIM_FIFO_DEPTH - fifoRdPtr;
        }

        // no new samples available
        else
        {
            numAvailSam = 0;
        }

        if ( numAvailSam > 0 )
        {
            uint8_t cmd = MAX30101_FIFO_DATA ;

            /**
             * read all the available samples,
             * FIFO RD pointer is implicitly incremented after each successful sample read
             */
            readRegs(cmd,tmpBuf,100);

            if ( NULL != dataBuff )
            {
                memcpy  (
                            (void*)dataBuff,
                            (const void*)tmpBuf,
                            numAvailSam * MAXIM_BYTES_PER_ADC_VALUE
                        );
            }
        }
    }

    /** save data */

    if ( NULL != sampleNum )
    {
        *sampleNum = numAvailSam;
    }

    
    return STATUS_MAXIM_SUCCESS;
 }
    
 float  MAX30101::getTemp(void)
 {
    float temp = 0;
    
    return temp;
 }
    
 float  MAX30101::getDieTemp(void)
 {
    float dieTemp = 0;
    
    
    return dieTemp;

 }

 uint8_t  MAX30101::getRevisionID(void)
 {
     uint8_t chipid = 0;
     
     readRegs(MAX30101_DeviceID, &chipid, 1);
     return chipid;
 }
  
 uint8_t  MAX30101::getChipID(void)
 {
     uint8_t chipid = 0;
     
     readRegs(MAX30101_DeviceID, &chipid, 1);
     return chipid;
 }
     
void MAX30101::readRegs(int addr, uint8_t * data, int len) 
{
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}
 
void MAX30101::writeRegs(uint8_t * data, int len) 
{
    m_i2c.write(m_addr, (char *)data, len);
}
     

uint8_t MAX30101::readRegister( uint8_t regaddr)
{
    uint8_t data = 0;
    readRegs(regaddr, &data,1);
    return data;
}

void MAX30101::writeRegister(uint8_t regaddr, uint8_t data)
{
    uint8_t i2data[2]= {regaddr, data};
    
    writeRegs(i2data, 2);
}
     