
//https://os.mbed.com/users/neilt6/code/SDFileSystem_HelloWorld/
#include <iostream>
#include "mbed.h"
#include "SDFileSystem.h"
#include "DS3231.h"
#include "RTC_Reader.h"
#include "sstream"
//======================================================================================
//========================== ADC Pin Configurations ====================================
//======================================================================================
AnalogIn analog_value1(PC_0); //ADC1 ADC1_IN10 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value2(PC_2); //ADC2 ADC1_IN12 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value3(PC_3); //ADC3 ADC1_IN13 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value4(PA_3); //ADC4 ADC1_IN3 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value5(PA_5); //ADC5 ADC1_IN5 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value6(PB_1); //ADC6 ADC1_IN9 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value7(PF_4); //ADC7 ADC3_IN14 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value8(PF_5); //ADC8 ADC3_IN15 Analog mode No pull-up and no pull-down n/a
AnalogIn analog_value9(PF_10);//ADC9 ADC3_IN8 Analog mode No pull-up and no pull-down n/a
//======================================================================================

//====================================================================================================
//================================= SD Card Pin Configuration ========================================
//====================================================================================================
//https://os.mbed.com/users/neilt6/code/SDFileSystem_HelloWorld/
//SDFileSystem::SDFileSystem(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name) : 
SDFileSystem sd(D11, D12, D13, D10, "G"); // the pinout on the mbed Cool Components workshop board
//====================================================================================================

using namespace std;

double analog[9];
int ID=1,
    counter,
    factor,
    Offset,
    tInterval,  //s
    OtInterval; //ms

void Print_Data_Sensor(float a1, float a2, float a3, float a4, float a5, float a6, float a7, float a8, float a9){
   printf("Data_Sensor1: %f mV\r\n", a1);
   printf("Data_Sensor2: %f mV\r\n", a2);
   printf("Data_Sensor3: %f mV\r\n", a3);
   printf("Data_Sensor4: %f mV\r\n", a4);
   printf("Data_Sensor5: %f mV\r\n", a5);
   printf("Data_Sensor6: %f mV\r\n", a6);
   printf("Data_Sensor7: %f mV\r\n", a7);
   printf("Data_Sensor8: %f mV\r\n", a8);
   printf("Data_Sensor9: %f mV\r\n\r\n", a9);
   wait(1); // 1 s
   }

void Print_Format_Data( 
        int tInt, int cnt,  int fctr,
        int ofst, float a1, float a2,
        float a3, float a4, float a5,
        float a6, float a7, float a8,
        float a9
        ){
            char sprtr='_';
            printf("%X %X ",sprtr,tInt);
            printf("%X %X ",sprtr,cnt);
            printf("%X %X ",sprtr,fctr);
            printf("%X %X ",sprtr,ofst);
            printf("%X %X ",sprtr,(int)a1);
            printf("%X %X ",sprtr,(int)a2);
            printf("%X %X ",sprtr,(int)a3);
            printf("%X %X ",sprtr,(int)a4);
            printf("%X %X ",sprtr,(int)a5);
            printf("%X %X ",sprtr,(int)a6);
            printf("%X %X ",sprtr,(int)a7);
            printf("%X %X ",sprtr,(int)a8);
            printf("%X %X ",sprtr,(int)a9);
            printf("\n\r");
            /*printf("_%d_%X_%X_%d_%X_%X_%X_%X_%X_%X_%X_%X_%X\r\n", 
                    tInt,cnt,fctr,ofst,
                    (int)a1,(int)a2,(int)a3,(int)a4,(int)a5,(int)a6,(int)a7,(int)a8,(int)a9
                    );*/
            wait(1); // 1 s
}

void Sampling_Data(){
    tInterval=1;
    OtInterval=tInterval*1000;
    counter++;
    factor=3300;
    Offset=0;
    analog[0]= (analog_value1.read()*factor)+Offset;
    analog[1]= (analog_value2.read()*factor)+Offset;
    analog[2]= (analog_value3.read()*factor)+Offset;
    analog[3]= (analog_value4.read()*factor)+Offset;
    analog[4]= (analog_value5.read()*factor)+Offset;
    analog[5]= (analog_value6.read()*factor)+Offset;
    analog[6]= (analog_value7.read()*factor)+Offset;
    analog[7]= (analog_value8.read()*factor)+Offset;
    analog[8]= (analog_value9.read()*factor)+Offset;
    }
    
string string_to_Hex(string decimal_value){
    stringstream ss;
    ss<< std::hex << decimal_value; // int decimal_value
    std::string res ( ss.str() );
    std::cout << res;
    return res;
}

int main()
{   
    RTC_READER_DS3231::RTC_ RTC_Ob;
    RTC_Ob.RTC_::Read_RTC_Data();
    printf("{%d_%02i-%02i-%02i/%02i:%02i:%02i}",ID,
            RTC_Ob.RTC_date, RTC_Ob.RTC_month, RTC_Ob.RTC_year,
            RTC_Ob.RTC_hour, RTC_Ob.RTC_minute,RTC_Ob.RTC_second);
    for(;;){
        Sampling_Data();
        Print_Format_Data(OtInterval,counter,factor,Offset,analog[0],analog[1],analog[2],analog[3],analog[4],analog[5],analog[6],analog[7],analog[8]);  
   }
}