#include "mbed.h"
#include "HMC5843.h"
#include "ADXL345.h"
#include "ITG3200.h"

DigitalOut myled(LED1);

HMC5843 cmp(p28, p27);      // sda, scl
ADXL345 acc(p28, p27);      // sda, scl
ITG3200 gyr(p28, p27);      // sda, scl
Serial pc(USBTX, USBRX);    // tx, rx

int main() {
    pc.baud(115200);
    //values x,y,z
    int readings[3];
    //ID Buffer
    char buffer[3];
    
    pc.printf("%c" ,13,10,13,10,13,10);
    
    // do init stuff
    //Continuous mode, , 10Hz measurement rate.
    // HMC5843_CONTINUOUS, HMC5843_10HZ_NORMAL HMC5843_1_0GA
    cmp.setDefault();
    //Wait some time(Need at least 5ms)
    wait(0.1);
    cmp.getAddress(buffer);
    pc.printf("cmp Id=%c%c%c \n\r",buffer[0],buffer[1],buffer[2]);
 
    // These are here to test whether any of the initialization fails. It will print the failure
    if (acc.setPowerControl(0x00)){
         pc.printf("acc: didn't intitialize power control\n"); 
         return 0;  }
    wait(.001);
    
    //Full resolution, +/-16g, 4mg/LSB.
    if(acc.setDataFormatControl(0x0B)){
        pc.printf("didn't set data format\n");
        return 0;  }
    wait(.001);
     
    //3.2kHz data rate.
    if(acc.setDataRate(ADXL345_3200HZ)){
        pc.printf("didn't set data rate\n");
        return 0;    }
    wait(.001);
     
    //Measurement mode.
    if(acc.setPowerControl(MeasurementMode)) {
        pc.printf("didn't set the power control to measurement\n"); 
        return 0;   } 

    pc.printf("Acc Id=%x \n\r", acc.getDeviceID());
    pc.printf("%c" ,13,10);

    //Set highest bandwidth.
    gyr.setLpBandwidth(LPFBW_256HZ);
    pc.printf("Gyro Id=%x \n\r", gyr.getWhoAmI());
    pc.printf("%c" ,13,10);

    wait(1);

    while (1) {

        cmp.readData(readings);
        pc.printf("C %+4i %+4i %+4i",(int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
        wait(0.05);

        acc.getOutput(readings);
        pc.printf(" A %+5i %+5i %+5i",(int16_t)readings[0],(int16_t)readings[1],(int16_t)readings[2]);
        wait(0.05);
        
        pc.printf(" G %+5i %+5i %+5i",(int16_t)gyr.getGyroX(),(int16_t)gyr.getGyroY(),(int16_t)gyr.getGyroZ());
        pc.printf("%c" ,13,10);        
        wait(0.05);
        
        if (myled) {
            myled=0;
        } else {
            myled=1;
        }
        
    }
}
