#include "USB_Helper.h"

/* cache flush */
void CPU_CACHE_Flush(uint32_t * buffer, uint32_t length)
{
 // SCB_InvalidateDCache_by_Addr(buffer,length);
  uint32_t ccsidr;
  uint32_t smask;
  uint32_t sshift;
  uint32_t ways;
  uint32_t wshift;
  uint32_t ssize;
  uint32_t sets;
  uint32_t sw;
  uint32_t start;
  uint32_t ende;

  start=(uint32_t)buffer;
  ende=start+length;
  /* Get the characteristics of the D-Cache */

  ccsidr = SCB->CCSIDR;
  smask  = CCSIDR_SETS(ccsidr);          /* (Number of sets) - 1 */
  sshift = CCSIDR_LSSHIFT(ccsidr) + 4;   /* log2(cache-line-size-in-bytes) */
  ways   = CCSIDR_WAYS(ccsidr);          /* (Number of ways) - 1 */

  /* Calculate the bit offset for the way field in the DCCISW register by
   * counting the number of leading zeroes.  For example:
   *
   *   Number of  Value of ways  Field
   *   Ways       'ways'         Offset
   *     2         1             31
   *     4         3             30
   *     8         7             29
   *   ...
   */

  wshift = __CLZ(ways) & 0x1f;

  /* Clean and invalidate the D-Cache over the range of addresses */

  ssize  = (1 << sshift);
  start &= ~(ssize - 1);
  __DSB();

  do
    {
      int32_t tmpways = ways;

      /* Isolate the cache line associated with this address.  For example
       * if the cache line size is 32 bytes and the cache size is 16KB, then
       *
       *   sshift = 5      : Offset to the beginning of the set field
       *   smask  = 0x007f : Mask of the set field
       */

      sets = ((uint32_t)start >> sshift) & smask;

      /* Clean and invalidate each way for this cacheline */

      do
        {
          sw = ((tmpways << wshift) | (sets << sshift));
          SCB->DCCISW=sw;

        }
      while (tmpways--);

      /* Increment the address by the size of one cache line. */

      start += ssize;
    }
  while (start < ende);

  __DSB();
  __ISB();
}
