#include "mbed.h"
#include "rtos.h"
#include "USBHostMouseKeyboard.h"
#include "USBHostMSD.h"
#define FastSpeedInterface 0
#define HighSpeedInterface 1
DigitalOut led(LED1);

void onMouseEventdev0(uint8_t buttons, int8_t x, int8_t y, int8_t z) {
    printf("0m: %d, x: %d, y: %d, z: %d\r\n", buttons, x, y, z);
}

void onKeydev0(uint8_t key) {
    printf("0Key: %c\r\n", key);
}


void mouse_task(void const *) {
    // At the moment only one Interface can be used for the Host due to the use of
    USBHostMouseKb dev0(FastSpeedInterface);
    while(1) {
        // try to connect
        while(!dev0.connect())
            Thread::wait(500);
        // when connected, attach handler
        dev0.attachMouseEvent(onMouseEventdev0);
        dev0.attachKb(onKeydev0);
        while(1)
        {

           USBHost::poll();
           Thread::wait(50);
        }

    }
}

void msd_task(void const *) {

    USBHostMSD msd("usb",HighSpeedInterface);
    int i = 0;
    int res;
    int error=0;
    while(1) {

        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
            printf("waiting\n");
        }

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        while(1) {

            // append a file
            FILE * fp = fopen("/usb/test1.txt", "a");

            if (fp != NULL) {
                res=fprintf(fp, "Hello fun USB Drive World: %d!\r\n", i++);
                printf("Goodbye World!\r\n");
                if (error==1)
                {
                printf("Goodbye New World!\r\n");
                error=0;
                }
                fclose(fp);
                if(res<0)
                {
                   printf("FILE write ERROR\r\n");
                   msd.unmount();
                   wait_ms(5000);
                   msd.mount() ;
                   error=1;
                }

            } else {
                printf("FILE == NULL\r\n");
                msd.unmount();
                wait_ms(5000);
                msd.mount() ;
                error=1;
            }

            Thread::wait(500);

            // if device disconnected, try to connect again
            if (!msd.connected())
                break;
        }

    }
}



int main() {
    Thread mouseTask(mouse_task, NULL, osPriorityNormal, 256 * 4);
    Thread msdTask(msd_task, NULL, osPriorityNormal, 1024 * 4);

    while(1) {
        led=!led;
        Thread::wait(500);
    }
}

