#include "mbed.h"
#include "SDFileSystem.h"
#include <stdio.h>

DigitalOut myled(LED1);
SDFileSystem sd("sd");

// trim '\n'
void ntrim(char *str)
{
    int i;
    for (i = 0; str[i] != 0; ++i);

    if (i > 0 && str[i - 1] == '\n')
        str[i - 1] = 0;
}


int main() { 
    printf("Starting Filetest"); 
    sd.mount();
    FILE * fp;
        fp = fopen("/sd/test.txt", "w");
        if (fp == NULL)
        {
            printf("open error!!\r\n");
            while(1);
        }
        fprintf(fp,"Writing to SD Card");
        fclose (fp);       
        fp = fopen("/sd/test.txt", "r");
        if (fp == NULL)
        {
            printf("open error!!\r\n");
            while(1);
        }
        // read text file
        char buf[1024];
        while (fgets(buf, sizeof(buf), fp) != NULL)
        {
            ntrim(buf);
            printf("%s\r\n", buf);
        }

        // file close
        fclose(fp);
    while(1) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
    }
}
