#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

char* topic;

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

DigitalOut led2(LED2);
InterruptIn button1(USER_BUTTON);
EthernetInterface eth;

/**
 Send the MQTT message to a requested topic
*/
int sendMessage(char* message,char* topic, MQTT::Client<MQTTNetwork, Countdown>* client){
    MQTT::Message msg;
 
    // QoS 0
    char buf[100];
    sprintf(buf, message);
    msg.qos = MQTT::QOS0;
    msg.retained = false;
    msg.dup = false;
    msg.payload = (void*)buf;
    msg.payloadlen = strlen(buf)+1;
    return client->publish(topic, msg);
}

int main(int argc, char* argv[])
{   
    //Startup
    if(eth.connect() != 0){
        printf("Error initializing the ethernet interface!");
        return -1;
    }
    printf("IP address %s\n",eth.get_ip_address());
    
    MQTTNetwork mqttNetwork(&eth);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    int rc = mqttNetwork.connect(BROKER_NAME, BROKER_PORT);
    if (rc != 0){
        printf("Error connection to MQTT Broker code: %d\n",rc);
        return -1;
    }
    printf("MQTT Broker connected!\n");
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "clientId-d9oe9aQeGh";
    data.username.cstring = "dieter";
    data.password.cstring = "123456";
    rc = client.connect(data);
    if (rc != 0){
        printf("Error MQTT connetion data code: %d\n",rc);
        return -1;
    }
    printf("MQTT client connected!\n");
    
    // Attach ISR to handle button press event
    button1.fall(callback(button1_onpressed_cb));
    
    //Program
    while(1){
       
        if(multiclick_state != 0){
            printf("Button pressed %d times\n", multiclick_state);
            switch(multiclick_state){
                case 1:
                    printf("Upvote\n");
                    sendMessage("UPVOTE","dieter",&client);
                    break;
                case 2:
                    printf("Downvote\n");
                    sendMessage("DOWNVOTE","dieter",&client);
                    break;
                case 3:
                    printf("Nothing\n");
                    break;
                case 4:
                    printf("Disconnecting...\n");
                    mqttNetwork.disconnect();
                    printf("Bye ;)\n");
                    return 1;
                default:
                    //DO nothing
                    break;       
            }   
            //Reset the multiclick state
            multiclick_state = 0;
        }
    }
    return 0;
}