/*
 * Copyright (c) 2006-2020 Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 */
#include "mbed.h"
#include "USBMIDI.h"

USBMIDI midi;

DigitalIn nota1(D8);
DigitalIn nota2(D9);
DigitalIn nota3(D10);
DigitalIn nota4(D11);
DigitalIn nota5(D12);
DigitalIn nota6(PTA17);
AnalogIn escala(A0);
DigitalOut myled(LED1);

int fact=0;

void key1(){
        midi.write(MIDIMessage::NoteOn(12+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(12+fact));
        myled=0;
        wait_ms(175);
}

void key2(){
        midi.write(MIDIMessage::NoteOn(13+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(13+fact));
        myled=0;
        wait_ms(175);
}

void key3(){
        midi.write(MIDIMessage::NoteOn(14+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(14+fact));
        myled=0;
        wait_ms(175);
}

void key4(){
        midi.write(MIDIMessage::NoteOn(15+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(15+fact));
        myled=0;
        wait_ms(175);
}

void key5(){
        midi.write(MIDIMessage::NoteOn(16+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(16+fact));
        myled=0;
        wait_ms(175);
}

void key6(){
        midi.write(MIDIMessage::NoteOn(17+fact));
        myled=1;
        wait_ms(175);
        midi.write(MIDIMessage::NoteOff(17+fact));
        myled=0;
        wait_ms(175);
}

void Botones(){
    if(nota1==1){
        key1();
    }else if (nota2==1) {
        key2();
    }else if (nota3==1) {
        key3();
    }else if (nota4==1) {
        key4();
    }else if (nota5==1) {
        key5();
    }else if (nota6==1) {
        key6();
    }else{
        midi.write(MIDIMessage::NoteOff(57));
    }
}



int main(){

    while (1){
        fact=escala.read()*64;
        Botones();    
    }
}