#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);

int main() {
    set_time(1589387262);  // Set RTC time to Wed, 28 Oct 2009 11:35:37

    while (true) {
        time_t seconds = time(NULL);
        
        pc.printf("Time as seconds since January 1, 1970 = %u\n\r", (unsigned int)seconds);
        
        pc.printf("Time as a basic string = %s\n\r", ctime(&seconds));

        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n\r", localtime(&seconds));
        pc.printf("Time as a custom formatted string = %s\n\r", buffer);
        
        wait(3);
    }
}


