/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto realiza un juego. El objetivo es eliminar aplastando
    a cada ladrón que aparece en pantalla, mediante la flecha que aparece
    en la pantalla LCD. Esto se logra presionando el botón de la tarjeta.
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
* ###########################################################################/

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "NewTextLCD.h" 
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      Barrido;                // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor
PwmOut      servo(PTE22);           // Inicializa el PWM
AnalogIn    sensor1 (PTB0);         // Inicializa Canal Analógico para sensor 1
Serial      terminal(USBTX, USBRX); // Inicializa la Comunicación Serial a la PC
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  
void Blinking_Led(void); 

TextLCD lcd(PTA1,PTA2,PTD3,PTA12,PTA4,PTA5,TextLCD::LCD20x4);
DigitalIn push(SW1);
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
                // Inicialización de variables, puertos e interrupciones
Barrido.attach_us(&Barrido_OnInterrupt, Rate);   // Le asigna el periodo de barrido de 1ms (Rate=1000)

terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
//        Blinking_Led();             // Parapadeo del LED por Software
        servo = sensor1.read(); 
//        terminal.printf("Blink \r\n");                           
    }
    
    int pattern[8];
    pattern[0] = 0x0e;           //  *
    pattern[1] = 0x0a;           //  * *
    pattern[2] = 0x0e;           //  * 
    pattern[3] = 0x04;           //   * 
    pattern[4] = 0x1f;           // ***     
    pattern[5] = 0x04;           //   * 
    pattern[6] = 0x0a;           //  * * 
    pattern[7] = 0x0a;           //  * *
    int pattern1[8];
    pattern1[0] = 0x0e;           //  *
    pattern1[1] = 0x0a;           //  * *
    pattern1[2] = 0x0e;           //  * 
    pattern1[3] = 0x15;           // * * *
    pattern1[4] = 0x0e;           //  *     
    pattern1[5] = 0x04;           //   * 
    pattern1[6] = 0x0a;           //  * * 
    pattern1[7] = 0x11;           // *   *
    int pattern2[8];
    pattern2[0] = 0x04;           //   *
    pattern2[1] = 0x0e;           //  *
    pattern2[2] = 0x1f;           // *** 
    pattern2[3] = 0x04;           //   * 
    pattern2[4] = 0x04;           //   *     
    pattern2[5] = 0x04;           //   * 
    pattern2[6] = 0x04;           //   * 
    pattern2[7] = 0x0e;           //  *
    lcd.writeCGRAM(0, pattern);
    lcd.writeCGRAM(1, pattern1);
    lcd.writeCGRAM(2, pattern2);
    /*Las líneas anteriores permiten realizar las figuras
    para el juego, como la flecha y los movimientos de
    los ladrones*/
    INICIO:
    int i=0,j=0,y=0,p=0;
    uint16_t time=15;        //en ms
    while(push==1){
    if(i==9||i==19)y++;
    if(i==29){
        y++;
        i=0;
    }
    if(j==20)j=0,y=0;
    p=y%2;
    lcd.locate(2,1);
    lcd.putc(p);
    lcd.locate(17,1);
    lcd.putc(p);
    lcd.locate(4,1);
    lcd.printf("Get all the\n      raiders!");
    wait_ms(time);
    i++;
    lcd.cls();
    }
    lcd.cls();
    lcd.locate(7,1);
    lcd.printf("START!");
    wait(1);
    lcd.cls();
    uint8_t atrapados=0,fallos=0,faltan=7;
    //Se muestran textos que dan indicaciones del juego.
    i=0;
   while(true){
    //***Siempre en pantalla*****
        lcd.locate(0,0);                //* 
        lcd.printf("Missing %i    Fails %i",faltan,fallos);
        lcd.locate(9,1);
        lcd.printf(">%i",atrapados);
    /*Se añaden contadores para administrar el número de 
    ladrones por atrapar y los fallos cometidos por el usuario.*/
    //*******Ladrón desplazándose******
        if(i==2||i==5)y++;
        if(i==8){
            j++;
            y++;
            i=0;
        }
        if(j==20)j=0,y=0;
        p=y%2;
        lcd.locate(j,2);
        lcd.putc(p);
        wait_ms(time);
        i++;
        lcd.cls();
    //***Capturando al ladrón**
        if(j>=5&&j<=13)time=6;
        else time=15;
        
        if(push==0){
            lcd.locate(11,2);
            lcd.putc(2);
            wait_ms(500);
            if(j==11){
                faltan--;
                atrapados++;
                lcd.cls();
                lcd.locate(8,1);
                lcd.printf("BIEN!");
                j=0;
                i=0;
                wait(1);
            }
            else{
                lcd.cls();
                lcd.locate(6,1);
                lcd.printf("FALLASTE!");
                fallos++;
                j=0;
                i=0;
                wait(1);
            }
        }
        else{
            lcd.locate(11,3);
            lcd.putc(2);
        }
        if(j==19){
            lcd.cls();
            lcd.locate(6,1);
            lcd.printf("FALLASTE!");
            fallos++;
            j=0;
            i=0;
            wait(1);
        }
        if(fallos==3){
            lcd.locate(4,1);
            lcd.printf("Perdiste xD :(");
            wait(2);
            goto INICIO;
        }
        if(atrapados==7){
            lcd.locate(4,1);
            lcd.printf("Ganaste! :D");
            wait(2);
            goto INICIO;
        }
        
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (Toggle the LED)
        counter = Rate;             // Restablece el contador
    } 
}
/* END Events */   
/*
__________
|
|  Funciones Prototipo
|_________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
        led_monitor = 0;        // turn the LED on
        wait_ms(200);           // 200 millisecond
        led_monitor = 1;        // turn the LED off
        wait_ms(1000);          // 1000 millisecond
}

/* END Program */

/* END Mbed */