#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
//#include "EthernetInterface.h"

//-------------------------------------------- definicion de uarts

Serial pc(USBTX, USBRX);                       //activar para manejar las dos conexiones uart.(no olvidar ordenar los cambios)

//Serial uart(USBTX, USBRX);                     //cambiar por el de abajo a la ahora de cargarlo en la placa, para testear con los modulos.
Serial uart(PC_6, PC_7);


//-------------------------------------------- definicion de etiquetas

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

InterruptIn button(BUTTON1);
DigitalOut myled(LED1);

//-------------------------------------------- definicion de variables globales

//const char* ECHO_SERVER_ADDRESS = "192.168.2.2";
//const int ECHO_SERVER_PORT = 7;

char ID[3]="C1";
char ST[3]="OK";
char AC[3]="";
char AK[3]="";

//char IDs[]="",STs[]="",ACs[]="",AKs[]="";

char buffer[32]="";
char* aux[10];

unsigned int L=0;

uint8_t text[30];

//char* acc[4]={"CN","DT","OK","ER"};
int SP=1;
int OP=1;
int x=0;
int yx=72, yy=142, yz=212;
int gx=72, gy=142, gz=212;
int mx=72, my=142, mz=212;


//-------------------------------------------- definicion de funciones

void first_connection(){
    
    //------------------------------ programa
    
    if(strcmp(aux[2],"CN") == 0){       
        uart.printf("<C1;OK;YE;51>");
        //time.start();
        }
    }



void encabezado_lcd(){
    
    //------------------------------ programa
    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"PRAXIS", CENTER_MODE);
    wait(3); // 3s
    lcd.Clear(LCD_COLOR_BLACK);
    };

void refrescar_lcd(){
    
    //------------------------------ programa
    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"PRAXIS", CENTER_MODE);
    
    x++;
    if(x==480){
        x=0;
        lcd.Clear(LCD_COLOR_BLACK);
        }
    
    lcd.DrawPixel(x, yx, LCD_COLOR_ORANGE);
    lcd.DrawPixel(x, yy, LCD_COLOR_YELLOW);
    lcd.DrawPixel(x, yz, LCD_COLOR_RED);
    
    wait(0.01); // 10 ms
    };

void blinkled(){
    myled = 1; // LED is ON
    wait(0.2); // 200 ms
    myled = 0; // LED is OFF
    wait(0.2); // 200 ms
    };

void speed(){
    
    //------------ variables locales
    
        
    //------------ programa
           
    uart.printf("<C1;OK;S%i;2F>",SP);
    
    SP++;
    
    if(SP==4){
        SP=1;
        }
    };

void borrar_buffer(char *cadena){
    
    //------------ variables locales
    
    int i=0;
    
    //------------ programa
    
    for(i=0;i<31;i++){
        //pc.putc(cadena[i]);
        cadena[i]=0x00;
        
        }
    };

void interrup(){
    
    //------------ variables locales
    
    char chksm=0;
    char c;
    int i=0;
    
    //------------ programa
    
    c=uart.getc();
    if(c=='<'){
        while(c!='>'){
            c=uart.getc();
            if(c!='>'){
                buffer[i++]=c;              //------------ carga buffer
                }
            }
        
        for(i=0;i<strlen(buffer)-2;i++){    //------------ calculo checksum
            chksm ^= buffer[i];
            }
        
        //uart.printf("%x",chksm);
        
        i=0;

        aux[i]=strtok(buffer,";");          //------------ separa la cadena

        do{
            //pc.puts(aux[i]);
            //pc.putc('-');
            i++;
            aux[i]=strtok(NULL, ";");
            }while(aux[i]!=NULL);
        
        
        //if(strcmp(aux[??],chksm) == 0){       //------------ comparar checksum (FALTA)
        //    pc.printf("checksum igual");
        //    }
        
        
        if(strcmp(aux[0],"T1") == 0){       //------------ tipo de sensor TIMER
            if(strcmp(aux[2],"CN") == 0){       
                uart.printf("<C1;OK;YE;51>");
                lcd.Clear(LCD_COLOR_BLACK);
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"TIMER", CENTER_MODE);
                //time.start();
                }
            
                if(strcmp(aux[2],"D1") == 0){
                               
                
                    lcd.DisplayStringAt(0, LINE(2+L), (uint8_t *) "Tiempo:", LEFT_MODE);
                    lcd.DisplayStringAt(130, LINE(2+L), (uint8_t *) aux[3], LEFT_MODE);
                    lcd.DisplayStringAt(160, LINE(2+L), (uint8_t *) ":", LEFT_MODE);
                    lcd.DisplayStringAt(170, LINE(2+L), (uint8_t *) aux[4], LEFT_MODE);
                    lcd.DisplayStringAt(200, LINE(2+L), (uint8_t *) ":", LEFT_MODE);
                    lcd.DisplayStringAt(210, LINE(2+L), (uint8_t *) aux[5], LEFT_MODE);
                    
                    L = L + 1;
                    
                    if(L==9){
                        L=0;
                        }
                }
            }
        
        if(strcmp(aux[0],"A1") == 0){       //------------ tipo de sensor TIMER
            if(strcmp(aux[2],"CN") == 0){       
                uart.printf("<C1;OK;YE;51>");
                lcd.Clear(LCD_COLOR_BLACK);
                //lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"ACEL - GIRO - MAG", CENTER_MODE); 
                //time.start();
                }
            
                if(strcmp(aux[2],"D1") == 0){
                    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"ACELEROMETRO", CENTER_MODE);               
                
                    lcd.DisplayStringAt(00, LINE(2+L), (uint8_t *) "X:", LEFT_MODE);
                    lcd.DisplayStringAt(30, LINE(2+L), (uint8_t *) aux[3], LEFT_MODE);
                    lcd.DisplayStringAt(80, LINE(2+L), (uint8_t *) "Y:", LEFT_MODE);
                    lcd.DisplayStringAt(110, LINE(2+L), (uint8_t *) aux[4], LEFT_MODE);
                    lcd.DisplayStringAt(160, LINE(2+L), (uint8_t *) "Z:", LEFT_MODE);
                    lcd.DisplayStringAt(190, LINE(2+L), (uint8_t *) aux[5], LEFT_MODE);
                    
                    L = L + 1;
                    
                    if(L==9){
                        L=0;
                        }
                }
                if(strcmp(aux[2],"D2") == 0){
                    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"GIROSCOPIO", CENTER_MODE);               
                
                    lcd.DisplayStringAt(00, LINE(2+L), (uint8_t *) "X:", LEFT_MODE);
                    lcd.DisplayStringAt(30, LINE(2+L), (uint8_t *) aux[3], LEFT_MODE);
                    lcd.DisplayStringAt(80, LINE(2+L), (uint8_t *) "Y:", LEFT_MODE);
                    lcd.DisplayStringAt(110, LINE(2+L), (uint8_t *) aux[4], LEFT_MODE);
                    lcd.DisplayStringAt(160, LINE(2+L), (uint8_t *) "Z:", LEFT_MODE);
                    lcd.DisplayStringAt(190, LINE(2+L), (uint8_t *) aux[5], LEFT_MODE);
                    
                    L = L + 1;
                    
                    if(L==9){
                        L=0;
                        }
                }
                if(strcmp(aux[2],"D3") == 0){
                    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"MAGNETOMETRO", CENTER_MODE);               
                
                    lcd.DisplayStringAt(00, LINE(2+L), (uint8_t *) "X:", LEFT_MODE);
                    lcd.DisplayStringAt(30, LINE(2+L), (uint8_t *) aux[3], LEFT_MODE);
                    lcd.DisplayStringAt(80, LINE(2+L), (uint8_t *) "Y:", LEFT_MODE);
                    lcd.DisplayStringAt(110, LINE(2+L), (uint8_t *) aux[4], LEFT_MODE);
                    lcd.DisplayStringAt(160, LINE(2+L), (uint8_t *) "Z:", LEFT_MODE);
                    lcd.DisplayStringAt(190, LINE(2+L), (uint8_t *) aux[5], LEFT_MODE);
                    
                    L = L + 1;
                    
                    if(L==9){
                        L=0;
                        }
                }
            }

            
        /*
        if(strcmp(aux[2],"D1") == 0){
            yx= 120 - *aux[3];
            yy= 190 - *aux[4];
            yz= 260 - *aux[5];
            pc.putc(yx);
            pc.putc(yy);
            pc.putc(yz);
            //uart.printf("<%s;%s;DT;2F>",ID,ST);
            }
        if(strcmp(aux[2],"D2") == 0){
            gx= 120 - *aux[3];
            gy= 190 - *aux[4];
            gz= 260 - *aux[5];
            //uart.printf("<%s;%s;DT;2F>",ID,ST);
            }
        if(strcmp(aux[2],"D3") == 0){
            mx= 120 - *aux[3];
            my= 190 - *aux[4];
            mz= 260 - *aux[5];
            //uart.printf("<%s;%s;DT;2F>",ID,ST);
            }        
            */
        }
    borrar_buffer(buffer);
    };

//codigo principal

int main() {
    
    pc.printf("Inicio de programa\n");     //cambiar   de destino al final
    //uart.printf("Inicio de programa\n");     
    encabezado_lcd();
    
    //------------------------------ Interrupciones
    
    button.rise(&speed);
    uart.attach(&interrup);
    
    //------------------------------ programa
    
    while(1) {
        
        //refrescar_lcd();
        //blinkled();
    }
}
