#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
 
SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk
DigitalOut cs(PTD0);
 
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
 
char c;
int cnt=0;
 
int main() 
{
    // Chip must be deselected
    cs = 1;
     
    int data_LSB = 0x05;
    int data_MSB_letto = 0x00;
    int data_LSB_letto = 0x00;
    
    // Setup the spi for 8 bit data
    spi.format(8,1);            //CPOL=0 , CPHA=1 ---> al fronte di salita inizia il bit
    spi.frequency(100000);     
    led_red = 1;
    led_green = 1;
    
    char data_MSB = 0xff;
    char data_RAM_LSB;
    char switch_lsb;
    
    while(1)
    {
        //lettura switch
        cs = 0;
        spi.write('#');
        spi.write(0x01);
        switch_lsb = spi.write(0x55);
        cs = 1;
        wait(0.0001);
        
         // write RAM
        cs = 0;
        spi.write('#');
        spi.write(0x06);
        spi.write(0x01); //address MSB
        spi.write(0x01);
        spi.write(0x01); // address LSB
        spi.write(data_MSB); // data MSB
        spi.write(switch_lsb); // data LSB
        do{
            c = spi.write(0xaa);
            led_red=0;
            cnt++;
            if(cnt > 1)
            {
                pc.printf("Bloccato in scrittura\n");
                wait(1);
                break;
            }
        }while(c != 0x40); //attendi '@'
        led_red=1;
        cnt=0;
        //pc.printf("@ Ricevuta dopo la scrittura\n");
        cs = 1;
        wait(0.001);
        
         // read RAM
        cs = 0;
        spi.write('#');
        spi.write(0x04);
        spi.write(0x01); //address MSB
        spi.write(0x01);
        spi.write(0x01); // address LSB
        do{
            c = spi.write(0xaa);
            led_green=0;
            cnt++;
            if(cnt > 10)
            {
                pc.printf("Bloccato in lettura\n");
                wait(1);
                break;
            }
        }while(c != 0x40); //attendi '@'
        led_green=1;
        cnt=0;
        //pc.printf("@ Ricevuta dopo la lettura di %c\n",c);
        spi.write(0xAA);
        data_RAM_LSB = spi.write(0xAA);
        cs = 1;
        wait(0.0001);
                
        //scrittura led
        cs = 0;
        spi.write('#');
        spi.write(0x02);
        spi.write(data_RAM_LSB);
        cs = 1;
        wait(0.0001);
        
        //lettura led
        cs = 0;
        spi.write('#');
        spi.write(0x03);
        int led = spi.write(0x55);
        cs = 1;
        
        wait(0.0001);
        
        // write RAM burst
        cs = 0;
        spi.write('#');
        spi.write(0x07);
        spi.write(0x01); //address MSB
        spi.write(0x01);
        spi.write(0x01); // address LSB
        for(int i=0;i<4;i++)
        {
          data_LSB = data_LSB + 1;
          spi.write(data_MSB); 
          spi.write(data_LSB); 
          //wait(1);
          while(spi.write(0xAA) != '@'); 
        }
        data_LSB = data_LSB + 1;
        spi.write(data_MSB); 
        spi.write(data_LSB);
        while(spi.write(0x40) != '@');
        data_LSB = 0x00;
        cs = 1;
        
        // read RAM burst
        cs = 0;
        spi.write('#');
        spi.write(0x05);
        spi.write(0x01); //address MSB
        spi.write(0x01);
        spi.write(0x01); // address LSB
        for(int i=0;i<4;i++)
        {
            while(spi.write(0xAA) != '@');// come sopra
            data_MSB_letto = spi.write(0x55);
            data_LSB_letto = spi.write(0x55);
            if( (data_MSB_letto != data_MSB) || (data_LSB_letto != data_LSB+i+1))
                led_green = 0;
            else led_green = 1;
        }
        while(spi.write(0x40) != '@');
        data_MSB_letto = spi.write(0x55);
        data_LSB_letto = spi.write(0x55);
        if( (data_MSB_letto != data_MSB) || (data_LSB_letto != data_LSB+5))
            led_green = 0;
        else led_green = 1;
        cs = 1;
        
        
            
        wait(0.0002);
    }
}