#include "mbed.h"
#include "SPI.h"
Serial pc (USBTX, USBRX); 
SPI spi_temp(PB_15, PB_14, PB_13); // mosi, miso, sclk
DigitalOut spi_cs(PB_12); // chip select

void temp_read ()
{
    spi_cs=0;
    wait(1);
    float data0[9], data1[9];
    float temp[9];
    spi_temp.write(0xA0);            // Sensor Temperature
    wait_us(200);
    data0[0] = spi_temp.write(0xFF); // Higher Byte
//    if (data0[0] < 128)             // Inside temp range
        wait_us(200);
        data1[0] = spi_temp.write(0xFF);     // Lower Byte 
        temp[0] = (256*data0[0] + data1[0]) / 10;    
         
//    else                            // Overshooting temp range
//        data1[0] = 0;
//        temp[0] = 85.0;   }       
    printf("Sensor %0.2f\n",temp[0]);    // Maximum Limit reached
    wait_us(200);
    for (int i = 1; i<=8; i++)      // For rest 8-pixels
    {
        uint8_t p = 0xA0 + i ;

        spi_temp.write(p);              // Deciding from 1st - 8th pixel
        wait_us(200);
        data0[i] = spi_temp.write(0xFF); // Higher Byte
        
//        if (data0[i] < 128)             // Inside temp range
//        {
            wait_us(200);
            data1[i] = spi_temp.write(0xFF);     // Lower Byte 
            temp[i] = (256*data0[i] + data1[i]) / 10;
//        }
//        else                            // Overshooting temp. range
//        {   data1[i] = 0;
//            temp[i] = 120.0;  }       
        printf("Pixel %d %0.2f\n",i,temp[i]);    // Maximum limit reached
    }
    spi_cs=1;      
}   

void spi_initialise()
{   spi_temp.format(8, 1);          //8-bits, Mode 1
    spi_temp.frequency(100000);     // 100 KHz frequency of SCLK
    spi_cs=1;
}

int main()
{
    printf("Temp Check\n");
    spi_initialise();
    temp_read();
}