/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

DigitalOut led1(LED1);
RawSerial my_uart(UART_TX, UART_RX);

#define SLEEP_TIME                  500 // (msec)

// main() runs in its own thread in the OS
int main()
{    
    //Change Baud Rate
    my_uart.baud(9600);
    my_uart.printf("%s\n\r", "UART Initialized");
    char* msg = "OFF";
    
    while (true) {
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        led1 ? (msg = "OFF"):(msg = "ON");
        my_uart.printf("LED STATE: %s\n\r", msg);
        wait_ms(SLEEP_TIME);
    }
}
