#include "mbed.h"
 
#define POSMAX 50       // en milimetros
#define POSDRAW 30      // en milimetros
#define BAUD 9600      // Configuracion de baudios
 
#define CM_EJECUTAR 0xff    //FF Ejecutar
#define CM_GUARDAR 0xfe     //FE Guardar
#define CM_VERTEX2D 0xfd    //FD Vertex
#define CM_DRAW 0xfc        //FC Dibujo
#define CM_NODRAW 0xfb      //FB No Dibujo
#define CM_STOP 0xfa        //FA Parada
#define CM_END 0xf0         //F0 Fin de Linea     //F9 MOTOR PASO A PASO //F1 Interrupcion F2 Pausa de la interrupcion
 
#define MEM_SIZE 10
#define MEM_TYPE uint32_t
 
int mem_head=0;
int mem_tail=0;
uint8_t full=0;
 
Serial pc(USBTX,USBRX); // Comunicación Serial
MEM_TYPE buffer[MEM_SIZE];
 
PwmOut ServoX(PB_2); //D2
PwmOut ServoY(PB_3); //D3
PwmOut ServoZ(PB_4); //D4
 
uint8_t  posx_old=0;     // posición anterior del eje X
uint8_t  posy_old=0;     // posición anterior del eje Y
uint8_t  ss_time=100;     // tiempo  de espera para moverse 1 mm en microsegundos
 
uint8_t mem_put(MEM_TYPE data)
{
    if (full)
        return 1;
    buffer[mem_head] = data;
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full =1;
 
    return 0;
}
uint8_t mem_get(MEM_TYPE* data)
{
    if (mem_head == 0)
        return 1; 
    if (mem_head == mem_tail)
        return 1; 
 
    *data = buffer[mem_tail];
    mem_tail += 1;
 
    return 0;
}
uint32_t mem_free()
{
 mem_head=0;
 full=0;
}
void sstime(uint8_t x, uint8_t y)
{
    double dx=abs(x-posx_old);
    double dy=abs(y-posy_old);
    double dist= sqrt(dx*dx+dy*dy);
    wait_ms((int)(ss_time*dist));
    posx_old = x;
    posy_old= y;
   
}
int coord2pulse(float coord)      // conversión de coordenadas en Y
{
    if(0 <= coord <= POSMAX)
        return int(700+coord*1900/50);
    return 700;
}
void vertex2d(uint8_t x, uint8_t y)     // Funcion de llamado de conversiones  X y Y
{                                   
    int pulseX = coord2pulse(x);
    int pulseY = coord2pulse(y);
    ServoX.pulsewidth_us(pulseX);
    ServoY.pulsewidth_us(pulseY);
    sstime(x,y);
    //wait_ms(ss_time);
}
void draw() // Función para enviarle la posicion  de dibujo a Z, lo mueve hacia abajo. 
    {
    ServoZ.pulsewidth_us(2500);
    pc.printf(" Dibujando...");
    wait_ms(ss_time*2);
    }
void nodraw() // Función para enviarle la posicion de no dibujar a  Z, lo mueve hacia arriba. 
    {     
    ServoZ.pulsewidth_us(700);
    pc.printf(" Dibujo Terminado...");
    wait_ms(ss_time*2);
    }
void ejecutar()
{
    pc.printf("se esta ejecutando el dibujo...");    
    
    uint32_t mem_free();
     
     while  (pc.getc() != CM_END)
        {
            void initdraw();    // posicion inicio de dibujo
            void memory();      //revisar memoria
            void dinamic ();    //memoria dinamica
            uint8_t mem_get (); //leer
                        
            switch (pc.getc())
            {
                 case CM_VERTEX2D:
                      
                      for (int i=0; i<4; i++){
                          void vertex2d(uint8_t x, uint8_t y);
                          }
                      break;
                 case CM_DRAW:
                      void draw ();
                      break;
                 case CM_NODRAW:
                      void nodraw ();
                      break;
                 default:
                      pc.printf("error de comando");
                      break ;     
            }
        }
}
void guardar()
{
    pc.printf("se inicia el comado de guardar..");    
 
    uint32_t mem_free();  
       while  (pc.getc() != CM_END)
        {
            void initdraw();  //posicion incial de dibujo
            void memory();
            void dinamic ();
            uint8_t mem_put(); //escribir
                        
         }   
}
void init_serial()      // configuracion de  baudios a pc
{
    pc.baud(BAUD);    
}
void init_servos()      // configuracion de  periodo
{
    ServoX.period_ms(20);
    ServoY.period_ms(20);
    ServoZ.period_ms(20);  
}
void init_draw(float x, float y)
{
    vertex2d (x,y);
    wait_ms(ss_time);
    draw();
}
void home()
{
    nodraw();
    vertex2d(0,0);
    pc.printf("Posicion Home");
    wait_ms(ss_time);
}
void put_sstime(uint8_t vtime)
{
    ss_time=vtime;
   
}
void parada ()
{   //subprograma de parada
    pc.printf("finalizando programa..");  
    uint32_t mem_free(); 
    void nodraw();
    void home();
}
void dinamic ()  // memoria dinamica de 32 bits
{
        int temp = pc.getc();
            
            temp = temp<<8 + pc.getc();
            temp = temp<<8 + pc.getc();
            temp = temp<<8 + pc.getc();
            temp = temp<<8 + pc.getc();
} 
void memory ()  // memoria  para obtener el dato
{     
        mem_put(pc.getc());
        mem_put(pc.getc());
        mem_put(pc.getc());
        mem_put(pc.getc());
        MEM_TYPE val;
        mem_get(&val);
        pc.putc(val);
}
 
int main() 
{       // programa para reconocer efecutar o guardar
    init_servos();
    init_serial();
    home();
    pc.printf ("inicializacion");
    char read_cc;
    while(1)
    {
        read_cc = pc.getc();
        switch (read_cc) {
            case  CM_EJECUTAR: ejecutar(); break;
            case  CM_GUARDAR: guardar(); break;
            case  CM_STOP: parada (); break;
            default: pc.printf("error de comando");break ;      
        }
    }
}