#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut ledr(PTA5);
DigitalOut ledg(PTA12);
DigitalOut ledb(PTC8);

int main() {
    char count[2];
    char RxDataCnt;
    char temp;
    float x;
    float y;
   

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2416);
     // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple 4 Byte Receiver\r\n" );
    
    RxDataCnt = 2;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
     while (1) {



        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );


            pc.printf( "Cnt %d = %d %d\r\n",temp,count[0],count[1]);
            x = (count[0]/70)-3.3;
            y = (count[1]/70)-3.3;
          
       if((x>-0.2 && x<0.2) && (y>-0.2 && y<0.2))
        {
                    
             ledg = 1;
             ledb = 1; 
             ledr = 0;
            
        }
        else if(((x>-0.6 && x<-0.2) | (x>0.2 && x<0.6)) || ((y>-0.6 && y<-0.2) | (y>0.2 && y<0.6)))
        {
            
             ledr = 1;
             ledb = 1; 
             ledg = 0;
            
        }
        else if((x<-0.6 | x>0.6) | (y<-0.6 | y>0.6))
        {
             ledg = 1;
             ledr = 1; 
             ledb = 0;
            
           
        }
        else
        {
            ledr = 1;
            ledg = 1;
            ledb = 1;
            
        }
        
             // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
          
        }
    }

}
