#include "mbed.h"
#include <string>
#include "GPS.h"
#include "EthernetPowerControl.h"
#include "MODSERIAL.h"

#define XBEETIMEOUT 5

class Camera
{
public:
    Camera(PinName gpsTx, PinName gpsRx, PinName xbTx, PinName xbRx, int freq, int len, int cdelay);
    GPS gps;
    bool init();
    void parseXbee();
    void parseGpsData();
    bool gpsReadable();
    bool xbeeReadable();
    
    DigitalOut L1;
    DigitalOut L2;
    DigitalOut L3;
    DigitalOut L4;    
    
private:
    MODSERIAL XBee;
    InterruptIn PPS;    
    char RxBuffer[256];
    
    bool PWMon;
    bool RxTO;
       
    int TimingOffset;
    int BeaconNumber;
   
    void ppsSync();
    void readDipSwitch();
    void initDipSwitch();
   
    // Pins are all bound to a mbed pin in the constructor
    // Digital pins for setting the Timing offset
    DigitalIn T1;
    DigitalIn T2;
    DigitalIn T3;
    DigitalIn T4;
    DigitalIn T5;
    DigitalIn T6;
    DigitalIn T7;
    DigitalIn T8;

    // Digital pins for setting the beacon number
    DigitalIn B1;
    DigitalIn B2;
    DigitalIn B3;
    DigitalIn B4;  
    
    int PulseFrequency;   //Hz
    int Pulselength; //usec
    int PWMclock; 
    int Period;
    int CameraDelay_us; //usec
    
    Timeout _CameraDelay;
    void cameraDelay();

    Timeout _RxTimeOut;
    void rxTimeOut();
    
    void startPWM();
    void stopPWM();
    void resetPWM(int _PulseFrequency, int _Pulselength);
    void printStatus();
    void getXbeeData();  
};  
