#pragma once
#ifndef LASER_H
#define LASER_H

#include "mbed.h"
#include <math.h>
#include <cstring>
#include <stdlib.h>
#include "SDFileSystem.h"
#include "esp8266.h"

extern Serial ser2usb;

//步进电机
DigitalOut step[2] = {DigitalOut(PC_5), DigitalOut(PA_5)}; //0--x P9,1--y P17
DigitalOut dir[2] = {DigitalOut(PC_4), DigitalOut(PA_4)}; //0--x,1--y
DigitalOut en[2] = {DigitalOut(PD_2), DigitalOut(PA_2)}; //0--x,1--y

class laser
{
public:
    laser(Esp8266 & iClient, SDFileSystem & iSD);
    void draw();
private:
    Esp8266 & client;
    SDFileSystem & sd;

    void moveto(float x, float y);
    void rotate(int id ,int pix);
    void markdot(float value);
    
    //电子开关,激光开关
    DigitalOut switch_GS;
    //行程开关
     DigitalIn switch_pos1;   //P25
     DigitalIn switch_pos2;  //P26
     DigitalIn switch_pos3;  //P27
    
    //运行中的全局变量
    volatile bool Working, Getawork, Isend, Dataused, Getdata;
    FILE *fp_drawing; // 存储图案的文件
    int status; //0: 初始化;  1:建立通信;  2:等候任务;  3:等待数据    4:正在执行一个任务
    int now_x, now_y;
    int Endoffile;
    
    // float thedata[50][3];
    // char sdata[1024];
    int Nofdata;
    bool ifreceive;
    
    //与实际有关参数
    float Lenoflattice ;//mm  取1mm为xy单元  unit_xy/Lenoflattice=100
    int unit_xy;  //单位长度(xy移动一格)对应unit_xy转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    int unit_x;  //单位长度(xy移动一格)对应unit_x转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    int unit_y;  //单位长度(xy移动一格)对应unit_y转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    ///Ticker ticker_step;
    float step_halfperiod;//0.0002;
    int max_x, max_y;
    int dir_x;///调试时调整
    int dir_y;///调试时调整
    int dot_max;      //灰度最大值对应多少次激光点击
    float dot_last;    //每次激光点击持续多久
    int H_max;  //灰度值最大值
    double k; //缩放比例
    double y;//图片y边长
    double x;//图片x边长
    int key;//判断变量
    int dot;//点计数
    int flag;
    int numbers[100][3];
    //char buf[100];
};


#endif
