#include "laser.h"

laser::laser(Esp8266 & iClient, SDFileSystem & iSD)
    :client(iClient), sd(iSD), 
    switch_GS(PC_15), 
    switch_pos1(PC_8),   //P25
    switch_pos2(PA_6),  //P26
    switch_pos3(PA_11),  //P27
    fp_drawing(NULL),
    status(0), Endoffile(0)
{
    Lenoflattice = 1 ;//mm  取1mm为xy单元  unit_xy/Lenoflattice=100
    unit_xy = 100;  //单位长度(xy移动一格)对应unit_xy转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    unit_x = 103;  //单位长度(xy移动一格)对应unit_x转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    unit_y = 103;  //单位长度(xy移动一格)对应unit_y转   大约10cm/3圈/9600step 约96mm/9600step=0.1mm/10step
    ///Ticker ticker_step;
    step_halfperiod = 0.0001;//0.0002;
    dir_x = 1;///调试时调整
    dir_y = 1;///调试时调整
    dot_max = 30;      //灰度最大值对应多少次激光点击
    dot_last = 0.005;    //每次激光点击持续多久
    H_max = 255;  //灰度值最大值
    k = 1.0; //缩放比例
    y=0;//图片y边长
    x=0;//图片x边长
    key=0;//判断变量
    dot=0;//点计数
    flag=0;
}

void laser::moveto(float x, float y)
{
    rotate(0, (x - now_x)*unit_xy);
    rotate(1, (y - now_y)*unit_xy);
    now_x = x;
    now_y = y;
}

void laser::rotate(int id, int pix) //id= 0--x,1--y  pix=3200为一圈
{
    if (pix >= 0) {
        dir[0] = dir_x;
        dir[1] = dir_y;
    } else {
        pix = -pix;
        dir[0] = 1 - dir_x;
        dir[1] = 1 - dir_y;
    }
    for (int i = 0; i < pix; i++) {
        step[id] = 1;
        wait(step_halfperiod);
        step[id] = 0;
        wait(step_halfperiod);
    }
}

void laser::markdot(float value)
{
    //switch_GS=1;
    int Ndot = floor(value * dot_max / H_max);
    for (int i = 0; i < Ndot; i++) {
        switch_GS = 1;
        wait(dot_last);
        switch_GS = 0;
    }
}

void laser::draw()
{
    unit_xy=unit_xy*k;
    float x, y, v;
    fp_drawing = fopen("/sd/write.txt", "r");
    ser2usb.printf("reading\r\n");
    for (int i = 0; fscanf(fp_drawing, "(%f,%f,%f)", &x, &y, &v) == 3; i++) 
    {
        ser2usb.printf("(%f,%f,%f)|%d|%d\r\n", x, y, v,i,dot);
        moveto(x, y);
        markdot(v);
    }
    fclose(fp_drawing);
}
